package com.offcn.im.demo.ui;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.offcn.im.demo.R;
import com.offcn.im.demo.util.LoginManager;
import com.offcn.im.demo.util.Utils;
import com.offcn.live.imkit.view.CircleImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

/**
 * 我
 */
public class MeFragment extends Fragment implements View.OnClickListener {
    TextView mTvLogout;
    TextView mTvName;
    CircleImageView mImageView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_me, null);

        mTvLogout = view.findViewById(R.id.btn_logout);
        mTvName = view.findViewById(R.id.name);
        mImageView = view.findViewById(R.id.avatar);

        mTvName.setText(LoginManager.getUserName(getActivity()));
        mTvLogout.setOnClickListener(this);
        Glide.with(getActivity()).load(LoginManager.getUserAvatar(getActivity()))
                .placeholder(R.mipmap.ic_teacher).into(mImageView);

        return view;
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.btn_logout:
                Utils.logout(getActivity());

                startActivity(new Intent(getActivity(), LoginActivity.class));
                getActivity().finish();
                break;
        }
    }
}
