package com.offcn.im.demo.ui;

import android.content.Intent;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;

import com.jyall.base.base.BaseActivity;
import com.jyall.base.base.H5Activity;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.ValidateUtils;
import com.offcn.im.demo.BuildConfig;
import com.offcn.im.demo.R;
import com.offcn.im.demo.bean.UserBean;
import com.offcn.im.demo.util.LoginManager;
import com.offcn.im.demo.util.MockData;
import com.offcn.im.demo.util.Utils;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * 登录页。三方业务页面
 */
public class LoginActivity extends BaseActivity {
    private static final String TAG = LoginActivity.class.getSimpleName();

    Spinner mSpinner;
    TextView mTvLogin;

    // 假数据
    private UserBean mSpinnerUser;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_login;
    }

    @Override
    protected void initViewsAndEvents() {
        mTvLogin = findViewById(R.id.tv_login);
        mTvLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                login();
            }
        });

        // 设置假数据
        mSpinner = findViewById(R.id.spinner);
        String[] userNames = MockData.getUserNames();
        ArrayAdapter<String> adapterFrom = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, userNames);
        adapterFrom.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinner.setAdapter(adapterFrom);
        mSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                ZGLLogUtils.e(TAG, "onItemSelected " + position);
                String spinnerName = userNames[position];
                mSpinnerUser = MockData.getUserByName(spinnerName);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
    }


    @Override
    protected void loadData() {

    }


    /**
     * 模拟登录接口，获得用户信息
     */
    private void login() {
        if (!CommonUtils.isNetConnected(this)) {
            CommonUtils.showToast(this, R.string.net_off);
            return;
        }
        if (mSpinnerUser == null) {
            CommonUtils.showToast(this, "请选择用户");
            return;
        }

        showLoading();

        // 模拟接口请求，耗时2秒
        mSpinner.postDelayed(new Runnable() {
            @Override
            public void run() {
                dismissLoading();
                ZGLLogUtils.e(TAG, mSpinnerUser.toString());
                // 保存登录信息
                LoginManager.login(LoginActivity.this, mSpinnerUser);
                // 跳转首页
                startActivity(new Intent(LoginActivity.this, MainActivity.class));
                finish();
            }
        }, 1000 * 2);
    }
}
