package com.offcn.im.demo.ui;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.view.View;
import android.widget.LinearLayout;

import com.jyall.base.base.BaseFragment;
import com.jyall.base.util.CommonUtils;
import com.offcn.im.demo.R;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLNetworkChangeReceiver;
import com.offcn.live.imkit.ui.ChatListFragment;

/**
 * 会话列表
 *
 * @author wangwenlong
 * @date 2020/12/9
 */
public class ChatListFragmentWrapper extends BaseFragment {
    private static final String TAG = ChatListFragmentWrapper.class.getSimpleName();

    LinearLayout mNoNetView;

    private ZGLNetworkChangeReceiver mNetworkChangeReceiver;


    @Override
    protected int getContentViewId() {
        return R.layout.fragment_chat_list_wrapper;
    }

    @Override
    protected void init(View view) {
        mNoNetView = view.findViewById(R.id.container_nonet);

        registerReceiver();

        ChatListFragment chatListFragment = (ChatListFragment) getChildFragmentManager().findFragmentById(R.id.chat_list_fragment);
        chatListFragment.setSessionTop("753977asdkjsajdka");
    }

    @Override
    protected boolean setLoadAlways() {
        return false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        unregisterReceiver();
    }

    /**
     * 监听网络
     */
    private void registerReceiver() {
        mNetworkChangeReceiver = new ZGLNetworkChangeReceiver();
        final IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        getActivity().registerReceiver(mNetworkChangeReceiver, intentFilter);
        mNetworkChangeReceiver.setOnNetChangeListener(new ZGLNetworkChangeReceiver.OnNetChangeListener() {
            @Override
            public void onConnected(boolean isWifi) {
                ZGLLogUtils.e(TAG, "onConnected");
                mNoNetView.setVisibility(View.GONE);
            }

            @Override
            public void onDisconnected() {
                mNoNetView.setVisibility(View.VISIBLE);
            }
        });
    }

    private void unregisterReceiver() {
        try {
            if (mNetworkChangeReceiver != null) {
                getActivity().unregisterReceiver(mNetworkChangeReceiver);
            }
        } catch (Exception e) {

        }
    }

}
