package com.offcn.im.demo.ui;

import android.net.Uri;
import android.text.TextUtils;

import com.jyall.base.base.BaseActivity;
import com.jyall.titleview.TitleView;
import com.offcn.im.demo.R;
import com.offcn.live.imkit.ui.ChatFragment;

/**
 * 聊天页面示例
 *
 * @author wangwenlong
 * @date 2020/12/7
 */
public class ChatActivity extends BaseActivity {
    private static final String TAG = ChatActivity.class.getSimpleName();

    TitleView mTitleView;
    ChatFragment mChatFragment;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_chat;
    }

    @Override
    protected boolean isAutoHideSoftEnable() {
        return false;
    }

    @Override
    protected void initViewsAndEvents() {
        // 聊天详情Fragment 需要接收 Uri 参数配置。由 startChat() 方法内部配置，外部直接调用即可
        Uri intentUri = getIntent().getData();
        if (intentUri == null) {
            finish();
            return;
        }

        String title = intentUri.getQueryParameter("title");

        mTitleView = findViewById(R.id.title_view);
        mTitleView.setTitleText(TextUtils.isEmpty(title) ? "会话详情" : title);
        mChatFragment = (ChatFragment) getSupportFragmentManager().findFragmentById(R.id.fragment_chat);
        mChatFragment.setUri(intentUri);
    }

    @Override
    protected void loadData() {

    }


    @Override
    public void onBackPressed() {
        // 先收起键盘
        if (mChatFragment != null && mChatFragment.hookOnBackPressed()) {
            return;
        }

        super.onBackPressed();
    }
}
