package com.offcn.im.demo;

import android.content.Context;

import com.jyall.base.util.EventBusCenter;
import com.jyall.base.util.EventBusUtil;
import com.jyall.base.util.ValidateUtils;
import com.offcn.im.demo.bean.UserBean;
import com.offcn.im.demo.util.Constants;
import com.offcn.im.demo.util.LoginManager;
import com.offcn.im.demo.util.MockData;
import com.offcn.live.im.OIMCallback;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMMsg;
import com.offcn.live.im.bean.OIMUserInfo;
import com.offcn.live.im.util.OIMDataManager;
import com.offcn.live.im.util.ZGLLogUtils;
import com.tencent.bugly.crashreport.CrashReport;

import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

public class MyApp extends MultiDexApplication {
    private static final String TAG = MyApp.class.getSimpleName();

    // 设置当前环境
    private boolean mEnvIsTest = false;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();

        Constants.ENV_IS_TEST = mEnvIsTest;
        // 初始化 OIMSDK
        initOIMSDK();
        // bugly
        CrashReport.initCrashReport(getApplicationContext(), "8e4fbab19e", true);
    }

    private void initOIMSDK() {
        // 初始化本地DB，用于存储用户信息。本示例数据直接由 MockData 提供
//        UserBeanDaoManager.getInstance().init(this);
        // 中公IM 初始化
        OIMSDK.init(this, mEnvIsTest);
        // 始终打印log 方便调试------------------记得上线前关闭
        ZGLLogUtils.setLogEnabled(true);
        // 中公IM 监听新消息
        OIMSDK.getInstance().setOnMsgListener(new OIMCallback.OnReceiveMsgListener() {
            @Override
            public void onMsg(OIMMsg oimMsg) {
                ZGLLogUtils.e(TAG, "onMsg 新消息");
                EventBusUtil.sendEvent(new EventBusCenter(Constants.EventCode.Code_New_Msg));
            }
        });
        // 中公IM 提供用户信息
        OIMSDK.getInstance().setUserInfoProvider(new OIMCallback.OnUserInfoProvider() {
            @Override
            public OIMUserInfo getUserInfo(String s) {
                if (ValidateUtils.isEmpty(s)) {
                    return null;
                }

                // 从DB中获取到用户信息，返回给SDK
                UserBean destUserBean = MockData.getUserById(s);
                if(destUserBean == null){
                    return null;
                }
                OIMUserInfo userInfo = new OIMUserInfo();
                userInfo.setUser_id(destUserBean.getUser_id());
                userInfo.setName(destUserBean.getName());
                userInfo.setAvatar(destUserBean.getAvatar());
                return userInfo;
            }

            @Override
            public OIMUserInfo getUserInfoPm(String s, String s1) {
                return null;
            }
        });
    }
}
