package com.offcn.imclient.util;

import android.content.Context;

import com.jyall.base.util.SharedPrefUtils;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.greendao.gen.DaoSession;
import com.offcn.imclient.greendao.gen.UserBeanDao;
import com.offcn.live.im.util.ZGLParseUtils;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

public class UserBeanDaoManager {
    private static final boolean DUBUG = true;
    private DaoManager manager;
    private UserBeanDao studentDao;
    private DaoSession daoSession;
    private Context mContext;

    private UserBeanDaoManager() {
    }

    private static UserBeanDaoManager INSTANCE = new UserBeanDaoManager();

    public static UserBeanDaoManager getInstance() {
        return INSTANCE;
    }

    public void init(Context context) {
        mContext = context;
        manager = DaoManager.getInstance();
        manager.init(context);
        daoSession = manager.getDaoSession();
        manager.setDebug(DUBUG);
        UserBeanDao.createTable(daoSession.getDatabase(), true);
    }

    /**
     * 添加数据，如果有重复则覆盖
     */
    public void insert(UserBean student) {
        manager.getDaoSession().insertOrReplace(student);
    }

    /**
     * 添加多条数据，需要开辟新的线程
     */
    public void insertMulti(final List<UserBean> students) {
        manager.getDaoSession().runInTx(new Runnable() {
            @Override
            public void run() {
                for (UserBean student : students) {
                    manager.getDaoSession().insertOrReplace(student);
                }
            }
        });
    }


    /**
     * 删除数据
     */
    public void deleteStudent(UserBean student) {
        manager.getDaoSession().delete(student);
    }

    /**
     * 删除全部数据
     */
    public void deleteAll() {
        manager.getDaoSession().deleteAll(UserBean.class);
    }

    /**
     * 更新数据
     */
    public void updateStudent(UserBean student) {
        manager.getDaoSession().update(student);
    }

    /**
     * 按照主键返回单条数据
     */
    public UserBean listOneStudent(long key) {
        return manager.getDaoSession().load(UserBean.class, key);
    }

    /**
     * 根据指定条件查询数据
     */
    public List<UserBean> queryStudent() {
        //查询构建器
        QueryBuilder<UserBean> builder = manager.getDaoSession().queryBuilder(UserBean.class);
        List<UserBean> list = builder.where(UserBeanDao.Properties.User_id.ge(1)).where(UserBeanDao.Properties.Name.like("王小二")).list();
        return list;
    }


    /**
     * 根据指定条件查询数据
     */
    public UserBean queryStudentByUserId(String userId) {
        //查询构建器
        try {
            QueryBuilder<UserBean> builder = manager.getDaoSession().queryBuilder(UserBean.class);
            UserBean userBean = builder.where(UserBeanDao.Properties.User_id.eq(userId)).limit(1).unique();
            return userBean;
        }catch (Exception e){
            return null;
        }
    }

    /**
     * 查询全部数据
     */
    public List<UserBean> queryAll() {
        return manager.getDaoSession().loadAll(UserBean.class);
    }
}
