package com.offcn.imclient.ui;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.offcn.live.im.bean.OIMMsg;
import com.offcn.live.im.bean.OIMMsgBody;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

/**
 * 推送通知栏点击处理类
 */
public class PushTranslateActivity extends AppCompatActivity {
    private static final String TAG = PushTranslateActivity.class.getSimpleName();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        String content = null;
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            content = bundle.getString("content");
        }
        if (!TextUtils.isEmpty(content)) {
            // 跳转到页面需要保证 OIMSDK 连接成功，所以建议先跳转到应用首页进行全局初始化操作，若跳转到聊天页需要先连接 OIMSDK 初始化
            ZGLLogUtils.e(TAG, "push : " + content);
            startActivity(new Intent(this, SplashActivity.class));

//            OIMMsg oimMsg = ZGLParseUtils.parseObjectByGson(content, OIMMsg.class);
//            if(oimMsg != null) {
//                OIMMsgBody msgBody = oimMsg.getBody();
//                if (msgBody != null) {
////                DemoChatActivity.newInstance(this, msgBody.getMsg_to(), msgBody.getMsg_from(), msgBody.getMsg_seq());
//                }
//            }

        }

        finish();
        overridePendingTransition(0, 0);
    }

}
