package com.offcn.imclient.ui;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;

import com.google.android.material.tabs.TabLayout;
import com.jyall.base.adapter.BaseVPAdapter;
import com.jyall.base.base.BaseActivity;
import com.jyall.base.util.CommonUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.live.im.OIMCallback;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMCode;
import com.offcn.live.im.util.ZGLCommonUtils;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.imkit.ui.ChatListFragment;

import java.util.ArrayList;
import java.util.List;

import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;

/**
 * tab主页。由最近会话和好友列表组成
 */
public class MainActivity extends BaseActivity {
    private static final String TAG = MainActivity.class.getSimpleName();

    TabLayout mTabLayout;
    ViewPager mViewPager;

    String[] titles = new String[]{"聊天", "通讯录", "我的"};

    private UserBean mUserBean;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_main;
    }

    @Override
    protected void initViewsAndEvents() {

        mTabLayout = findViewById(R.id.tab_layout);
        mViewPager = findViewById(R.id.view_pager);

        mUserBean = LoginManager.getUser(this);
        if (mUserBean == null) {
            CommonUtils.showToast(this, "用户信息获取失败");
            finish();
            return;
        }

        OIMSDK.getInstance().connect(mUserBean.getUser_id(), mUserBean.getToken(), new OIMCallback.OnConnectListener() {
            @Override
            public void onStateConnected() {
                ZGLLogUtils.e(TAG, "IM连接成功");
//                ZGLCommonUtils.showToast(MainActivity.this, "IM连接成功");
            }

            @Override
            public void onStateDisconnected(int code, String error) {
                ZGLLogUtils.e(TAG, "IM连接失败 " + code + " " + error);
                ZGLCommonUtils.showToast(MainActivity.this, "IM连接失败 " + code + " " + error);
                // 连接失败超时，和部分情况作特殊处理如退出页面：token失效、被踢
                if (code == OIMCode.Code_IM_Connect_Fail
                        || code == OIMCode.Code_IM_Connect_Timeout
                        || code == OIMCode.Code_IM_Error_TokenInvalid
                        || code == OIMCode.Code_IM_Disconnect_Kick
                        || code == OIMCode.Code_IM_Error_NoExist) {

                    // 此处注释。内部已调用 destroy() 方法。
//                    OIMSDK.getInstance(DemoMainActivity.this).destroy();
                    // 注销登录信息
                    LoginManager.logout(MainActivity.this);
                    UserBeanDaoManager.getInstance().deleteAll();

                    AlertDialog dialog = new AlertDialog.Builder(MainActivity.this)
                            .setTitle("IM连接失败")
                            .setMessage(code + "," + error)
                            .setPositiveButton("退出", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    startActivity(new Intent(MainActivity.this, LoginActivity.class));
                                    finish();
                                }
                            })
                            .setCancelable(false)
                            .create();
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.show();
                }
            }

            @Override
            public void onStateReconnecting() {
                ZGLLogUtils.e(TAG, "IM重连");
            }
        });


        List<Fragment> fragmentList = new ArrayList<>();
        fragmentList.add(new ChatListFragment());
        fragmentList.add(new ContactListFragment());
        fragmentList.add(new MeFragment());
        for (int i = 0; i < titles.length; i++) {
            mTabLayout.addTab(mTabLayout.newTab());
        }
        BaseVPAdapter adapter = new BaseVPAdapter(getSupportFragmentManager(), fragmentList);
        mViewPager.setOffscreenPageLimit(fragmentList.size());
        mViewPager.setAdapter(adapter);
        mTabLayout.setupWithViewPager(mViewPager, false);
        for (int i = 0; i < titles.length; i++) {
            mTabLayout.getTabAt(i).setText(titles[i]);
        }
    }

    @Override
    protected void loadData() {

    }

    @Override
    protected void onResume() {
        super.onResume();

        // 清除通知栏消息
        OIMSDK.getInstance().clearNotification();
    }

    @Override
    public void onBackPressed() {
//        super.onBackPressed();
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.addCategory(Intent.CATEGORY_HOME);
        startActivity(intent);
    }
}
