package com.offcn.imclient.ui;

import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.jyall.base.base.BaseActivity;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.LoginManager;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import org.json.JSONObject;

/**
 * 登录页
 *
 * @author wangwenlong
 * @date 2020/12/10
 */
public class LoginActivity extends BaseActivity {
    private static final String TAG = LoginActivity.class.getSimpleName();

    EditText mEtName, mEtPwd;
    TextView mTvLogin;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_login;
    }

    @Override
    protected void initViewsAndEvents() {
        mEtName = findViewById(R.id.et_name);
        mEtPwd = findViewById(R.id.et_pwd);
        mTvLogin = findViewById(R.id.tv_login);

        mTvLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String name = mEtName.getText().toString().trim();
                String pwd = mEtPwd.getText().toString().trim();
                login(name, pwd);
            }
        });
        findViewById(R.id.tv_login_test).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                login("lqy62094", "lqy62094");
            }
        });
    }


    @Override
    protected void loadData() {

    }


    private void login(String name, String pwd) {
        if (ValidateUtils.isEmpty(name) || ValidateUtils.isEmpty(pwd)) {
            CommonUtils.showToast(this, "请输入用户名或密码");
            return;
        }

        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("username", name);
            jsonObject.put("password", pwd);

            RequestQueue requestQueue = Volley.newRequestQueue(this);
            JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(Request.Method.POST, "http://api.study.t.eoffcn.com/web/v2/im/login", jsonObject,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e(TAG, "login success " + response.toString());
                            try {
                                if (response.getInt("code") == 0) {
                                    if (response.getJSONObject("data") == null || response.getJSONObject("data").getJSONObject("user_info") == null) {
                                        CommonUtils.showToast(LoginActivity.this, "用户信息获取失败");
                                        return;
                                    }
                                    UserBean userBean = ZGLParseUtils.parseObjectByGson(response.getJSONObject("data").getJSONObject("user_info").toString(), UserBean.class);
                                    if (userBean != null) {
                                        ZGLLogUtils.e(TAG, userBean.toString());
                                        LoginManager.login(LoginActivity.this, userBean);
                                        startActivity(new Intent(LoginActivity.this, MainActivity.class));
                                        finish();
                                    } else {
                                        CommonUtils.showToast(LoginActivity.this, "用户信息获取失败");
                                    }
                                } else {
                                    CommonUtils.showToast(LoginActivity.this, response.getString("msg"));
                                }
                            } catch (Exception e) {
                                CommonUtils.showToast(LoginActivity.this, "用户信息解析失败");
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e(TAG, "login error " + error.toString());
                    CommonUtils.showToast(LoginActivity.this, error.toString());
                }
            }
            );
            requestQueue.add(jsonObjectRequest);
        } catch (Exception e) {

        }
    }
}
