package com.offcn.imclient.ui;

import android.content.Intent;
import android.view.View;
import android.widget.ExpandableListView;
import android.widget.RelativeLayout;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.jyall.base.base.BaseFragment;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.adapter.ContactListExpandableAdapter;
import com.offcn.imclient.bean.ServerContactBean;
import com.offcn.imclient.bean.ServerContactBeanWrapper;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.imclient.util.Utils;
import com.offcn.imclient.view.AnimatedExpandableListView;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMSendTypeEnum;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import org.json.JSONObject;

import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.ArrayList;
import java.util.List;

/**
 * 通讯录页
 *
 * @author wangwenlong
 * @date 2020/12/9
 */
public class ContactListFragment extends BaseFragment {
    private static final String TAG = ContactListFragment.class.getSimpleName();

    private RelativeLayout mContainerContact;
    private AnimatedExpandableListView mRecyclerView;

    private List<ServerContactBean> friends = new ArrayList<>();
    private ContactListExpandableAdapter mAdapter;

    @Override
    protected int getContentViewId() {
        return R.layout.fragment_contact_list;
    }

    @Override
    protected void init(View view) {
        mContainerContact = view.findViewById(R.id.container_list);
        mRecyclerView = view.findViewById(R.id.recycler_view);
        mAdapter = new ContactListExpandableAdapter(getContext(), friends);
        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.setOnChildClickListener(new ExpandableListView.OnChildClickListener() {
            @Override
            public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id) {
                if (childPosition == 0) {
                    // 说明是自定义的群发条目
                    ServerContactBean contactBean = friends.get(groupPosition);
                    if (contactBean != null) {
                        // 群发消息。收集当前群所有用户id，传给聊天页
                        String title = contactBean.getKey();
                        String toId = "";
                        StringBuilder stringBuilder = new StringBuilder();
                        List<UserBean> tmpList = contactBean.getList();
                        if (!ValidateUtils.isEmpty(tmpList)) {
                            for (int i = 0; i < tmpList.size(); i++) {
                                UserBean tmp = tmpList.get(i);
                                stringBuilder.append(tmp.getUser_id());
                                if (i != tmpList.size() - 1) {
                                    stringBuilder.append(",");
                                }
                            }
                            toId = stringBuilder.toString();
                            OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.GROUP, toId, title, 0);
                        } else {
                            CommonUtils.showToast(getActivity(), "该课程下暂无学生");
                        }
                    } else {
                        CommonUtils.showToast(getActivity(), "获取课程信息失败");
                    }
                } else {
                    UserBean userBean = friends.get(groupPosition).getList().get(childPosition);
                    if (userBean != null) {
                        OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.PRIVATE, userBean.getUser_id(), userBean.getName(), 0);
                    } else {
                        CommonUtils.showToast(getActivity(), "获取学生信息失败");
                    }
                }

                return true;
            }
        });
        mRecyclerView.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener() {
            @Override
            public boolean onGroupClick(ExpandableListView parent, View v, int groupPosition, long id) {
                if (mRecyclerView.isGroupExpanded(groupPosition)) {
                    mRecyclerView.collapseGroupWithAnimation(groupPosition);
                } else {
                    mRecyclerView.expandGroupWithAnimation(groupPosition);
                }
                return true;
            }
        });
        mAdapter.setOnContactItemElementClickListener(new ContactListExpandableAdapter.OnContactItemElementClickListener() {
            @Override
            public void onClickChat(int groupPosition, int childPosition) {
                ServerContactBean contactBean = friends.get(groupPosition);
                if (contactBean != null) {
                    // 群发消息。收集当前群所有用户id，传给聊天页
                    String title = contactBean.getKey();
                    String toId = "";
                    StringBuilder stringBuilder = new StringBuilder();
                    List<UserBean> tmpList = contactBean.getList();
                    if (!ValidateUtils.isEmpty(tmpList)) {
                        for (int i = 0; i < tmpList.size(); i++) {
                            UserBean tmp = tmpList.get(i);
                            stringBuilder.append(tmp.getUser_id());
                            if (i != tmpList.size() - 1) {
                                stringBuilder.append(",");
                            }
                        }
                        toId = stringBuilder.toString();
                        OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.GROUP, toId, title, 0);
                    } else {
                        CommonUtils.showToast(getActivity(), "该课程下暂无学生");
                    }
                }
            }
        });

        getContactList();

    }

    @Override
    protected boolean setLoadAlways() {
        return false;
    }

    @Override
    protected View isNeedEmpty() {
        return mContainerContact;
    }

    @Override
    protected void initEmptyResource() {
        setEmptyRes("暂无联系人", R.mipmap.ic_empty_contact);
        setErrorRes("联系人获取失败", 0);
        setErrorClickListner(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getContactList();
            }
        });
    }

    private void getContactList() {
        if (!CommonUtils.isNetConnected(getActivity())) {
            showNoNetView();
            return;
        }

        showLoading();

        try {
            JSONObject jsonObject = new JSONObject();

            jsonObject.put("im_token", LoginManager.getToken(getActivity()));

            RequestQueue requestQueue = Volley.newRequestQueue(getActivity());
            JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(Request.Method.POST, "http://api.study.t.eoffcn.com/web/v2/im/userlist", jsonObject,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            ZGLLogUtils.e(TAG, "contact success " + response.toString());
                            dismissLoading();
                            try {
                                int rtnCode = response.getInt("code");
                                if (rtnCode == 0) {
                                    ServerContactBeanWrapper beanWrapper = ZGLParseUtils.parseObjectByGson(response.getJSONObject("data").toString(), ServerContactBeanWrapper.class);
                                    if (beanWrapper != null && !ValidateUtils.isEmpty(beanWrapper.user_list)) {
                                        friends = beanWrapper.user_list;
                                        exeContactList();
                                    } else {
                                        // 数据为空
                                        friends.clear();
                                        showEmptyView();
                                    }
                                } else if (rtnCode == 1 || rtnCode == 2) {
                                    //  {"code":1,"msg":"登陆过期，请重新登陆","params":{"im_token":"0XR5YOS6dg7x2lirfeX3CbjRLqPWmesaFbdsr\/M4IRZS4mYYyZILI82FT8dgqybCA4W+MxfjJDY=@ip6c.cn.rongnav.com;ip6c.cn.rongcfg.com"}}
                                    Utils.logout(getActivity());
                                    startActivity(new Intent(getActivity(), LoginActivity.class));
                                    getActivity().finish();
                                    CommonUtils.showToast(getActivity(), response.getString("msg"));
                                } else {
                                    showErrorView();
                                    CommonUtils.showToast(getActivity(), response.getString("msg"));
                                }
                            } catch (Exception e) {
                                showErrorView();
                                CommonUtils.showToast(getActivity(), "联系人获取失败");
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ZGLLogUtils.e(TAG, "contact error " + error.toString());
                    dismissLoading();
                    CommonUtils.showToast(getActivity(), error.toString());
                }
            }
            );
            requestQueue.add(jsonObjectRequest);
        } catch (Exception e) {
            dismissLoading();
        }
    }

    private void exeContactList() {
        if (!ValidateUtils.isEmpty(friends)) {
            showNormalContent();
            for (ServerContactBean serverContactBean : friends) {
                serverContactBean.getList().add(0, new UserBean("", "群发消息", ""));
            }
            mAdapter.setData(friends);
            List<UserBean> userBeanList = new ArrayList<>();
            for (ServerContactBean contactBean : friends) {
                userBeanList.addAll(contactBean.getList());
            }
            UserBeanDaoManager.getInstance().insertMulti(userBeanList);
        } else {
            showEmptyView();
            UserBeanDaoManager.getInstance().deleteAll();
        }
    }
}
