package com.offcn.imclient.ui;

import android.net.Uri;
import android.text.TextUtils;

import com.jyall.base.base.BaseActivity;
import com.jyall.titleview.TitleView;
import com.jyall.titleview.TitleViewCompatible;
import com.offcn.imclient.R;
import com.offcn.live.imkit.ui.ChatFragment;

/**
 * 聊天页面示例
 *
 * @author wangwenlong
 * @date 2020/12/7
 */
public class ChatActivity extends BaseActivity {
    private static final String TAG = ChatActivity.class.getSimpleName();

    TitleView mTitleView;
    ChatFragment mChatFragment;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_chat;
    }

    @Override
    protected void initViewsAndEvents() {
        Uri intentUri = getIntent().getData();
        if (intentUri == null) {
            finish();
            return;
        }

        String title = intentUri.getQueryParameter("title");
        String targetId = intentUri.getQueryParameter("targetId");
        long lastSeq = Long.parseLong(intentUri.getQueryParameter("lastSeq"));

        mTitleView = findViewById(R.id.title_view);
        mTitleView.setTitleText(TextUtils.isEmpty(title) ? "会话详情" : title);
        mChatFragment = (ChatFragment) getSupportFragmentManager().findFragmentById(R.id.fragment_chat);
        mChatFragment.setUri(intentUri);
    }

    @Override
    protected void loadData() {

    }


    @Override
    public void onBackPressed() {
        if (mChatFragment != null && mChatFragment.hookOnBackPressed()) {
            return;
        }
        super.onBackPressed();
    }
}
