package com.offcn.imclient.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.jyall.base.adapter.BaseRecyclerViewAdapter;
import com.jyall.base.adapter.RecyclerViewHolderUtil;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.bean.ServerContactBean;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.view.AnimatedExpandableListView;
import com.offcn.live.imkit.view.CircleImageView;

import java.util.ArrayList;
import java.util.List;

/**
 * 最近会话列表适配器
 *
 * @author wangwenlong
 * @date 2020/9/11
 */
public class ContactListExpandableAdapter extends AnimatedExpandableListView.AnimatedExpandableListAdapter {

    private LayoutInflater inflater;

    private List<ServerContactBean> items;

    public ContactListExpandableAdapter(Context context, List<ServerContactBean> list) {
        inflater = LayoutInflater.from(context);
        items = list;
    }

    public void setData(List<ServerContactBean> items) {
        this.items = items;
        notifyDataSetChanged();
    }

    @Override
    public UserBean getChild(int groupPosition, int childPosition) {
        return items.get(groupPosition).getList().get(childPosition);
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public View getRealChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ChildHolder holder;
        UserBean item = getChild(groupPosition, childPosition);
        if (convertView == null) {
            holder = new ChildHolder();
            convertView = inflater.inflate(R.layout.item_contact_child, parent, false);
            holder.title = (TextView) convertView.findViewById(R.id.tv_name);
            convertView.setTag(holder);
        } else {
            holder = (ChildHolder) convertView.getTag();
        }

        holder.title.setText(item.getName());

        return convertView;
    }

    @Override
    public int getRealChildrenCount(int groupPosition) {
        return items.get(groupPosition).getList().size();
    }

    @Override
    public ServerContactBean getGroup(int groupPosition) {
        return items.get(groupPosition);
    }

    @Override
    public int getGroupCount() {
        return items.size();
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupHolder holder;
        ServerContactBean item = getGroup(groupPosition);
        if (convertView == null) {
            holder = new GroupHolder();
            convertView = inflater.inflate(R.layout.item_contact_group, parent, false);
            holder.title = (TextView) convertView.findViewById(R.id.tv_name);
            holder.count = (TextView) convertView.findViewById(R.id.tv_count);
            holder.ivChat = convertView.findViewById(R.id.iv_chat);
            convertView.setTag(holder);
        } else {
            holder = (GroupHolder) convertView.getTag();
        }

        holder.title.setText(item.getKey());
        int itemCount = 1;
        if (!ValidateUtils.isEmpty(item.getList())) {
            itemCount = item.getList().size();
        }
        --itemCount;
        if (itemCount <= 0) {
            holder.count.setVisibility(View.GONE);
        } else {
            holder.count.setVisibility(View.VISIBLE);
            holder.count.setText(String.valueOf(itemCount));
        }
        holder.ivChat.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mOnContactItemElementClickListener != null) {
                    mOnContactItemElementClickListener.onClickChat(groupPosition, 0);
                }
            }
        });

        return convertView;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isChildSelectable(int arg0, int arg1) {
        return true;
    }


    private static class ChildHolder {
        TextView title;
        ImageView avatar;
    }

    private static class GroupHolder {
        TextView title;
        TextView count;
        ImageView ivChat;
    }


    public void setOnContactItemElementClickListener(OnContactItemElementClickListener onContactItemElementClickListener) {
        mOnContactItemElementClickListener = onContactItemElementClickListener;
    }

    OnContactItemElementClickListener mOnContactItemElementClickListener;

    public interface OnContactItemElementClickListener {
        void onClickChat(int groupPosition, int childPosition);
    }
}
