package com.offcn.imclient.adapter;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.jyall.base.adapter.BaseRecyclerViewAdapter;
import com.jyall.base.adapter.RecyclerViewHolderUtil;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.bean.UserBean;
import com.offcn.live.im.bean.OIMUserInfo;
import com.offcn.live.imkit.view.CircleImageView;

import java.util.List;

/**
 * 最近会话列表适配器
 *
 * @author wangwenlong
 * @date 2020/9/11
 */
public class ContactListAdapter extends BaseRecyclerViewAdapter<UserBean> {
    public ContactListAdapter(Context paramContext) {
        super(paramContext);
    }

    public ContactListAdapter(Context context, List<UserBean> list) {
        super(context, list);
    }

    @Override
    public int onCreateViewLayoutID(int i) {
        return R.layout.item_contact_list;
    }

    @Override
    public void bindItemViewHolder(RecyclerViewHolderUtil holderUtil, int position) {
        CircleImageView mHeadImg = holderUtil.get(R.id.rc_img);
        TextView mTvName = holderUtil.get(R.id.tv_name);
        View line = holderUtil.get(R.id.view_line);

        UserBean friend = getItem(position);
        if (friend == null) {
            return;
        }
//        String sectionForPosition = getSectionForPosition(position);
//        if (position == getPositionForSection(sectionForPosition)) {
//            mTvCategory.setVisibility(View.VISIBLE);
//            mTvCategory.setText(friend.getFirst_char());
//        } else {
//            mTvCategory.setVisibility(View.GONE);
//            mTvCategory.setText("");
//        }

//        if (friend.isLast()) {
//            line.setVisibility(View.GONE);
//        } else {
//            line.setVisibility(View.VISIBLE);
//        }

        RequestOptions options = new RequestOptions();
        options.placeholder(R.mipmap.ic_teacher).error(R.mipmap.ic_teacher);
        options.diskCacheStrategy(DiskCacheStrategy.ALL);

        mTvName.setText(friend.getName());
        if (friend.getAvatar().startsWith("file")) {
            Uri uri = Uri.parse(friend.getAvatar());
            Glide.with(mContext).load(uri).apply(options).into(mHeadImg);
        } else {
            Glide.with(mContext).load(friend.getAvatar()).apply(options).into(mHeadImg);
        }
    }


//    public String getSectionForPosition(int position) {
//        if (!ValidateUtils.isEmpty(mList)) {
//            UserBean friend = getItem(position);
//            if (friend != null) {
//                String firstChar = friend.getFirst_char();
//                if (!TextUtils.isEmpty(firstChar)) {
//                    return firstChar;
//                } else {
//                    return "";
//                }
//
//            } else {
//                return "";
//            }
//        } else {
//            return "";
//        }
//
//    }
//
//    public int getPositionForSection(String section) {
//        if (ValidateUtils.isEmpty(mList)) {
//            return -1;
//        }
//        for (int i = 0; i < mList.size(); i++) {
//            UserBean friend = getItem(i);
//            if (friend != null) {
//                String sortStr = friend.getFirst_char();
//                if (!TextUtils.isEmpty(sortStr)) {
//                    if (sortStr.equals(section)) {
//                        return i;
//                    }
//                }
//            }
//        }
//        return -1;
//    }
}
