package com.offcn.imclient.util;

import android.content.Context;
import android.text.TextUtils;

import com.jyall.base.util.SharedPrefUtils;
import com.offcn.imclient.bean.UserBean;
import com.offcn.live.im.util.ZGLParseUtils;

/**
 * 登录工具类
 */
public class LoginManager {
    private static final String KEY_USER = "login_user";


    public static boolean isLogin(Context context) {
        return getUser(context) != null;
    }

    public static void login(Context context, UserBean userBean) {
        SharedPrefUtils.setParam(context, KEY_USER, ZGLParseUtils.parseToJson(userBean));
    }

    public static String getUserId(Context context) {
        if(getUser(context) == null){
            return null;
        }
        return getUser(context).getUser_id();
    }

    public static String getUserName(Context context) {
        if(getUser(context) == null){
            return null;
        }
        return getUser(context).getName();
    }

    public static String getUserAvatar(Context context) {
        if(getUser(context) == null){
            return null;
        }
        return getUser(context).getAvatar();
    }

    public static String getToken(Context context) {
        if(getUser(context) == null){
            return null;
        }
        return getUser(context).getToken();
    }


    public static UserBean getUser(Context context) {
        String userJson = String.valueOf(SharedPrefUtils.getParam(context, KEY_USER, ""));
        if(TextUtils.isEmpty(userJson)){
            return null;
        }
        return ZGLParseUtils.parseObjectByGson(userJson, UserBean.class);
    }

    public static void logout(Context context) {
        SharedPrefUtils.clear(context);
    }
}
