package com.offcn.imclient.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.view.WindowManager;

import com.jyall.base.base.BaseActivity;
import com.offcn.imclient.R;
import com.offcn.imclient.util.LoginManager;
import com.offcn.live.im.util.ZGLUtils;

/**
 * 闪屏页
 *
 * @author wangwenlong
 * @date 2020/12/10
 */
public class SplashActivity extends BaseActivity {
    private static final String TAG = SplashActivity.class.getSimpleName();

    @Override
    protected int getContentViewLayoutId() {
        return 0;
    }

    @Override
    protected void initViewsAndEvents() {

        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode
                    = WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
            getWindow().setAttributes(lp);
        }
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION);


        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                exeLogin();
            }
        }, 1000 * 2);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        getWindow().setBackgroundDrawable(null);
    }

    @Override
    protected void loadData() {

    }


    private void exeLogin() {
        if (LoginManager.isLogin(this)) {
            startActivity(new Intent(this, MainActivity.class));
        } else {
            startActivity(new Intent(this, LoginActivity.class));
        }

        finish();
    }
}
