package com.offcn.imclient.util;

import android.content.Context;

import com.offcn.imclient.bean.UserBean;
import com.offcn.live.im.OIMSDK;

public class Utils {
    /**
     * 退出登录，销毁
     *
     * @param context
     */
    public static void logout(Context context) {
        OIMSDK.getInstance().destroy();
        LoginManager.logout(context);
        UserBeanDaoManager.getInstance().deleteAll();
    }


    public static String getServerLoginUrl() {
        if (Constants.ENV_IS_TEST) {
            return "http://api.study.t.eoffcn.com/web/v2/im/login";
        } else {
            return "http://api.study.eoffcn.com/web/v2/im/login";
        }
    }

    public static String getServerContactUrl() {
        if (Constants.ENV_IS_TEST) {
            return "http://api.study.t.eoffcn.com/web/v2/im/userlist";
        } else {
            return "http://api.study.eoffcn.com/web/v2/im/userlist";
        }
    }
}
