package com.offcn.imclient.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.jyall.base.base.BaseActivity;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.KeyboardUtils;
import com.jyall.base.util.ValidateUtils;
import com.jyall.base.view.ClearEditText;
import com.offcn.imclient.R;
import com.offcn.imclient.adapter.ContactSearchAdapter;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMSendTypeEnum;
import com.offcn.live.im.util.ZGLLogUtils;

import java.util.List;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * 搜索页
 *
 * @author wangwenlong
 * @date 2020/12/21
 */
public class SearchActivity extends BaseActivity {
    private static final String TAG = SearchActivity.class.getSimpleName();

    ClearEditText mEditText;
    TextView mTvCancel;
    RecyclerView mRecyclerView;
    LinearLayout mContainerContent, mContainerNone;

    private ContactSearchAdapter mSearchAdapter;

    @Override
    protected int getContentViewLayoutId() {
        return R.layout.activity_search;
    }

    @Override
    protected void initViewsAndEvents() {
        mEditText = findViewById(R.id.et_search);
        mTvCancel = findViewById(R.id.tv_cancel);
        mRecyclerView = findViewById(R.id.recycler_view);
        mContainerContent = findViewById(R.id.container_content);
        mContainerNone = findViewById(R.id.container_none);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
        linearLayoutManager.setOrientation(RecyclerView.VERTICAL);
        mRecyclerView.setLayoutManager(linearLayoutManager);
        mRecyclerView.setAdapter(mSearchAdapter = new ContactSearchAdapter(this));
        mSearchAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                UserBean userBean = mSearchAdapter.getItem(position);
                if (userBean != null) {
                    OIMSDK.getInstance().startChat(SearchActivity.this, OIMSendTypeEnum.PRIVATE, userBean.getUser_id(), userBean.getName(), 0);
                } else {
                    CommonUtils.showToast(SearchActivity.this, "获取学生信息失败");
                }
            }
        });

        mTvCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
                overridePendingTransition(R.anim.push_bottom_still, R.anim.push_bottom_out);
            }
        });

        mEditText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s == null || s.length() == 0 || TextUtils.isEmpty(s.toString().trim())) {
                    mContainerContent.setVisibility(View.GONE);
                    mContainerNone.setVisibility(View.GONE);
                    mSearchAdapter.clear();
                    return;
                }

                String content = s.toString().trim();
                searchStudentByContent(content);
            }
        });

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                KeyboardUtils.showSoftInput(SearchActivity.this, mEditText);
            }
        }, 300);
    }

    @Override
    protected void loadData() {

    }

    @Override
    public void onBackPressed() {
        finish();
        overridePendingTransition(R.anim.push_bottom_still, R.anim.push_bottom_out);
    }

    /**
     * 查询学生
     *
     * @param content
     */
    private void searchStudentByContent(String content) {
        ZGLLogUtils.e(TAG, "searchStudentByContent " + content);

        List<UserBean> list = UserBeanDaoManager.getInstance().queryByNameOrMobile(content);
        if (ValidateUtils.isEmpty(list)) {
            mContainerContent.setVisibility(View.GONE);
            mContainerNone.setVisibility(View.VISIBLE);
            mSearchAdapter.clear();
        } else {
            mContainerNone.setVisibility(View.GONE);
            mContainerContent.setVisibility(View.VISIBLE);
            mSearchAdapter.clear();
            mSearchAdapter.addAll(list);
        }
    }

}
