package com.offcn.imclient.ui;

import android.content.Intent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ExpandableListView;
import android.widget.RelativeLayout;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.jyall.base.base.BaseFragment;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.EventBusCenter;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.adapter.ContactListExpandableAdapter;
import com.offcn.imclient.bean.ServerContactBean;
import com.offcn.imclient.bean.ServerContactBeanWrapper;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.Constants;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.imclient.util.Utils;
import com.offcn.imclient.view.AnimatedExpandableListView;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMSendTypeEnum;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.json.JSONObject;

import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;

import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

/**
 * 通讯录页
 *
 * @author wangwenlong
 * @date 2020/12/9
 */
public class ContactListFragment extends BaseFragment {
    private static final String TAG = ContactListFragment.class.getSimpleName();

    private RelativeLayout mContainerContact;
    private AnimatedExpandableListView mRecyclerView;
    private RelativeLayout mSearch;
    private SwipeRefreshLayout mSwipeRefreshLayout;

    private List<ServerContactBean> friends = new ArrayList<>();
    private ContactListExpandableAdapter mAdapter;

    @Override
    protected int getContentViewId() {
        return R.layout.fragment_contact_list;
    }

    @Override
    protected boolean isRegisterEventBus() {
        return true;
    }

    @Override
    protected void init(View view) {
        mContainerContact = view.findViewById(R.id.container_list);
        mRecyclerView = view.findViewById(R.id.recycler_view);
        mSwipeRefreshLayout = view.findViewById(R.id.refresh_layout);
        mSearch = view.findViewById(R.id.search);

        mSwipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                getContactList();
            }
        });

        mAdapter = new ContactListExpandableAdapter(getContext(), friends);
        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.setOnScrollListener(new AbsListView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(AbsListView view, int scrollState) {

            }

            @Override
            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                View firstView = view.getChildAt(firstVisibleItem);
                if (firstVisibleItem == 0 && (firstView == null || firstView.getTop() == 0)) {
                    mSwipeRefreshLayout.setEnabled(true);
                } else {
                    mSwipeRefreshLayout.setEnabled(false);
                }
            }
        });
        mRecyclerView.setOnChildClickListener(new ExpandableListView.OnChildClickListener() {
            @Override
            public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id) {
                if (childPosition == 0) {
                    // 说明是自定义的群发条目
                    ServerContactBean contactBean = friends.get(groupPosition);
                    if (contactBean != null) {
                        // 群发消息。收集当前群所有用户id，传给聊天页
                        String title = contactBean.getKey();
                        String toId = "";
                        StringBuilder stringBuilder = new StringBuilder();
                        List<UserBean> tmpList = contactBean.getList();
                        if (!ValidateUtils.isEmpty(tmpList)) {
                            for (int i = 0; i < tmpList.size(); i++) {
                                UserBean tmp = tmpList.get(i);
                                if (tmp != null && !ValidateUtils.isEmpty(tmp.getUser_id())) {
                                    stringBuilder.append(tmp.getUser_id());
                                    if (i != tmpList.size() - 1) {
                                        stringBuilder.append(",");
                                    }
                                }
                            }
                            toId = stringBuilder.toString();
                            OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.GROUP, toId, title, 0);
                        } else {
                            CommonUtils.showToast(getActivity(), "暂无学员");
                        }
                    } else {
                        CommonUtils.showToast(getActivity(), "获取课程信息失败");
                    }
                } else {
                    UserBean userBean = friends.get(groupPosition).getList().get(childPosition);
                    if (userBean != null) {
                        OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.PRIVATE, userBean.getUser_id(), userBean.getName(), 0);
                    } else {
                        CommonUtils.showToast(getActivity(), "获取学生信息失败");
                    }
                }

                return true;
            }
        });
        mRecyclerView.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener() {
            @Override
            public boolean onGroupClick(ExpandableListView parent, View v, int groupPosition, long id) {
                if (mRecyclerView.isGroupExpanded(groupPosition)) {
                    mRecyclerView.collapseGroupWithAnimation(groupPosition);
                } else {
                    mRecyclerView.expandGroupWithAnimation(groupPosition);
                }
                return true;
            }
        });
        mAdapter.setOnContactItemElementClickListener(new ContactListExpandableAdapter.OnContactItemElementClickListener() {
            @Override
            public void onClickChat(int groupPosition, int childPosition) {
                ServerContactBean contactBean = friends.get(groupPosition);
                if (contactBean != null) {
                    // 群发消息。收集当前群所有用户id，传给聊天页
                    String title = contactBean.getKey();
                    String toId = "";
                    StringBuilder stringBuilder = new StringBuilder();
                    List<UserBean> tmpList = contactBean.getList();
                    if (!ValidateUtils.isEmpty(tmpList)) {
                        for (int i = 0; i < tmpList.size(); i++) {
                            UserBean tmp = tmpList.get(i);
                            if (tmp != null && !ValidateUtils.isEmpty(tmp.getUser_id())) {
                                stringBuilder.append(tmp.getUser_id());
                                if (i != tmpList.size() - 1) {
                                    stringBuilder.append(",");
                                }
                            }
                        }
                        toId = stringBuilder.toString();
                        OIMSDK.getInstance().startChat(getActivity(), OIMSendTypeEnum.GROUP, toId, title, 0);
                    } else {
                        CommonUtils.showToast(getActivity(), "暂无学员");
                    }
                }
            }
        });
        mSearch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!CommonUtils.isFastDoubleClick()) {
                    startActivity(new Intent(getActivity(), SearchActivity.class));
                    getActivity().overridePendingTransition(R.anim.push_bottom_in, R.anim.push_bottom_still);
                }
            }
        });

        getContactList();
    }

    @Override
    protected boolean setLoadAlways() {
        return false;
    }

    @Override
    protected View isNeedEmpty() {
        return mContainerContact;
    }

    @Override
    protected void initEmptyResource() {
        setEmptyRes("暂无联系人", R.mipmap.ic_empty_contact);
        setErrorRes("联系人获取失败", 0);
        setErrorClickListner(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getContactList();
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();

        if (!ValidateUtils.isEmpty(friends)) {
            for (int i = 0; i < friends.size(); i++) {
                if (mRecyclerView.isGroupExpanded(i)) {
                    mRecyclerView.collapseGroup(i);
                    int finalI = i;
                    mRecyclerView.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            mRecyclerView.expandGroup(finalI);
                        }
                    }, 100);
                }
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventBus(EventBusCenter eventBusCenter) {
//        int eventCode = eventBusCenter.getEvenCode();
//        if (eventCode == Constants.EventCode.Code_Refresh_Contact) {
//
//        }
    }

    private void getContactList() {
        if (!CommonUtils.isNetConnected(getActivity())) {
            showNoNetView();
            return;
        }

//        showLoading();

        try {
            JSONObject jsonObject = new JSONObject();

            jsonObject.put("im_token", LoginManager.getToken(getActivity()));

            RequestQueue requestQueue = Volley.newRequestQueue(getActivity());
            JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(Request.Method.POST, Utils.getServerContactUrl(), jsonObject,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            ZGLLogUtils.e(TAG, "contact success " + response.toString());
                            dismissLoading();
                            if (mSwipeRefreshLayout != null) {
                                mSwipeRefreshLayout.setRefreshing(false);
                            }
                            UserBeanDaoManager.getInstance().deleteAll();
                            try {
                                int rtnCode = response.getInt("code");
                                if (rtnCode == 0) {
                                    ServerContactBeanWrapper beanWrapper = ZGLParseUtils.parseObjectByGson(response.getJSONObject("data").toString(), ServerContactBeanWrapper.class);
                                    if (beanWrapper != null) {
                                        friends = beanWrapper.user_list;
                                    } else {
                                        // 数据为空
                                        friends.clear();
                                    }

                                    exeContactList();
                                } else if (rtnCode == 1 || rtnCode == 2) {
                                    //  {"code":1,"msg":"登陆过期，请重新登陆","params":{"im_token":"0XR5YOS6dg7x2lirfeX3CbjRLqPWmesaFbdsr\/M4IRZS4mYYyZILI82FT8dgqybCA4W+MxfjJDY=@ip6c.cn.rongnav.com;ip6c.cn.rongcfg.com"}}
                                    Utils.logout(getActivity());
                                    startActivity(new Intent(getActivity(), LoginActivity.class));
                                    getActivity().finish();
                                    String errorMsg = "登录异常";
                                    if (response.has("msg")) {
                                        errorMsg = response.getString("msg");
                                    }
                                    if (response.has("message")) {
                                        errorMsg = response.getString("message");
                                    }
                                    CommonUtils.showToast(getActivity(), errorMsg);
                                } else {
                                    showErrorView();
                                    String errorMsg = "获取联系人失败";
                                    if (response.has("msg")) {
                                        errorMsg = response.getString("msg");
                                    }
                                    if (response.has("message")) {
                                        errorMsg = response.getString("message");
                                    }
                                    CommonUtils.showToast(getActivity(), errorMsg);
                                }
                            } catch (Exception e) {
                                showErrorView();
                                CommonUtils.showToast(getActivity(), "获取联系人失败");
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ZGLLogUtils.e(TAG, "contact error " + error.toString());
                    dismissLoading();
                    if (mSwipeRefreshLayout != null) {
                        mSwipeRefreshLayout.setRefreshing(false);
                    }
                    CommonUtils.showToast(getActivity(), error.toString());
                }
            }
            );
            requestQueue.add(jsonObjectRequest);
        } catch (Exception e) {
            dismissLoading();
        }
    }

    private void exeContactList() {
        if (!ValidateUtils.isEmpty(friends)) {
            showNormalContent();
            for (ServerContactBean serverContactBean : friends) {
                serverContactBean.getList().add(0, new UserBean());
            }
            mAdapter.setData(friends);
            List<UserBean> userBeanList = new ArrayList<>();
            for (ServerContactBean contactBean : friends) {
                userBeanList.addAll(contactBean.getList());
            }
            UserBeanDaoManager.getInstance().insertMulti(userBeanList);
            OIMSDK.getInstance().refreshUserData();
        } else {
            showEmptyView();
            UserBeanDaoManager.getInstance().deleteAll();
        }
    }
}
