package com.offcn.imclient.ui;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.view.View;
import android.widget.ExpandableListView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.Volley;
import com.jyall.base.base.BaseFragment;
import com.jyall.base.util.CommonUtils;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.R;
import com.offcn.imclient.adapter.ContactListExpandableAdapter;
import com.offcn.imclient.bean.ServerContactBean;
import com.offcn.imclient.bean.ServerContactBeanWrapper;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.imclient.util.Utils;
import com.offcn.imclient.view.AnimatedExpandableListView;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMSendTypeEnum;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLNetworkChangeReceiver;
import com.offcn.live.im.util.ZGLParseUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 会话列表
 *
 * @author wangwenlong
 * @date 2020/12/9
 */
public class ChatListFragmentWrapper extends BaseFragment {
    private static final String TAG = ChatListFragmentWrapper.class.getSimpleName();

    LinearLayout mNoNetView;

    private ZGLNetworkChangeReceiver mNetworkChangeReceiver;


    @Override
    protected int getContentViewId() {
        return R.layout.fragment_chat_list_wrapper;
    }

    @Override
    protected void init(View view) {
        mNoNetView = view.findViewById(R.id.container_nonet);

        view.findViewById(R.id.search).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!CommonUtils.isFastDoubleClick()) {
                    startActivity(new Intent(getActivity(), SearchActivity.class));
                    getActivity().overridePendingTransition(R.anim.push_bottom_in, R.anim.push_bottom_still);
                }
            }
        });

        initNet();
    }

    @Override
    protected boolean setLoadAlways() {
        return false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        try {
            if (mNetworkChangeReceiver != null) {
                getActivity().unregisterReceiver(mNetworkChangeReceiver);
            }

        } catch (Exception e) {

        }
    }


    private void initNet() {
        mNetworkChangeReceiver = new ZGLNetworkChangeReceiver();
        final IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        getActivity().registerReceiver(mNetworkChangeReceiver, intentFilter);
        mNetworkChangeReceiver.setOnNetChangeListener(new ZGLNetworkChangeReceiver.OnNetChangeListener() {
            @Override
            public void onConnected(boolean isWifi) {
                ZGLLogUtils.e(TAG, "onConnected");
                mNoNetView.setVisibility(View.GONE);
            }

            @Override
            public void onDisconnected() {
                mNoNetView.setVisibility(View.VISIBLE);
            }
        });
    }
}
