package com.offcn.imclient;

import android.content.Context;

import com.jyall.base.util.EventBusCenter;
import com.jyall.base.util.EventBusUtil;
import com.jyall.base.util.ValidateUtils;
import com.offcn.imclient.bean.UserBean;
import com.offcn.imclient.util.Constants;
import com.offcn.imclient.util.LoginManager;
import com.offcn.imclient.util.UserBeanDaoManager;
import com.offcn.live.im.OIMCallback;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMMsg;
import com.offcn.live.im.bean.OIMUserInfo;
import com.offcn.live.im.util.ZGLLogUtils;
import com.tencent.bugly.crashreport.CrashReport;

import java.util.logging.LogManager;

import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

public class MyApp extends MultiDexApplication {
    private static final String TAG = MyApp.class.getSimpleName();

    private boolean mEnvIsTest = false;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();

        Constants.ENV_IS_TEST = mEnvIsTest;
        // 初始化 OIMSDK
        initOIMSDK();
        // bugly
        CrashReport.initCrashReport(getApplicationContext(), "8cda8831f2", true);
    }

    private void initOIMSDK() {
        UserBeanDaoManager.getInstance().init(this);
        OIMSDK.init(this, mEnvIsTest);
        ZGLLogUtils.setLogEnabled(true);
        OIMSDK.getInstance().setOnUnreadMsgCountChangedListener(new OIMCallback.OnUnreadMsgCountChangedListener() {
            @Override
            public void onCountChanged(int count) {
                ZGLLogUtils.e(TAG, "onCountChanged " + count);
                EventBusUtil.sendEvent(new EventBusCenter(Constants.EventCode.Code_Count_Changed, count));
            }
        });
        OIMSDK.getInstance().setOnMsgListener(new OIMCallback.OnReceiveMsgListener() {
            @Override
            public void onMsg(OIMMsg oimMsg) {
                ZGLLogUtils.e(TAG, "onMsg 新消息");
                EventBusUtil.sendEvent(new EventBusCenter(Constants.EventCode.Code_New_Msg));
            }
        });
        OIMSDK.getInstance().setUserInfoProvider(new OIMCallback.OnUserInfoProvider() {
            @Override
            public OIMUserInfo getUserInfo(String s) {
                if (ValidateUtils.isEmpty(s)) {
                    return null;
                }
                // 当前登录用户
                UserBean destUserBean;
                if (s.equals(LoginManager.getUserId(getApplicationContext()))) {
                    destUserBean = LoginManager.getUser(getApplicationContext());
                } else {
                    destUserBean = UserBeanDaoManager.getInstance().queryStudentByUserId(s);
                }
                if (destUserBean == null) {
                    return null;
                }
                OIMUserInfo userInfo = new OIMUserInfo();
                userInfo.setUser_id(destUserBean.getUser_id());
                userInfo.setName(destUserBean.getName());
                userInfo.setAvatar(destUserBean.getAvatar());
                return userInfo;
            }
        });
    }
}
