//
//  OffcnSmallClassSDK.h
//  OffcnLiveSDK
//
//  Created by vockey on 2020/7/2.
//  Copyright © 2020 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

//事件回调枚举
typedef NS_ENUM(NSUInteger, OffcnSmallClassSDKEvent) {
    OffcnSmallClassSDKEventUserLogin = 1,  //用户登录事件回调
    OffcnSmallClassSDKEventUserLogout,     //用户退出事件回调
    OffcnSmallClassSDKEventJoin,           //加入会话事件回调
    OffcnSmallClassSDKEventPush,           //上台事件回调
    OffcnSmallClassSDKEventPub,            //用户上台连麦（包含自己）事件回调
    OffcnSmallClassSDKEventUnPub,          //用户下台断麦（包含自己）事件回调
    OffcnSmallClassSDKEventSub,            //拉流成功事件回调
    OffcnSmallClassSDKEventMuteRemoteAudio,      //停止,恢复接受指定音频流事件回调
    OffcnSmallClassSDKEventMuteRemoteVideo,      //停止,恢复接受指定视频流事件回调
    OffcnSmallClassSDKEventStartPreview,   //开启视频预览事件回调
    OffcnSmallClassSDKEventConnect,        //长连接状态事件回调
    OffcnSmallClassSDKEventOnlineNumberUpdate,   //房间实时人数变更事件回调
    OffcnSmallClassSDKEventEquipmentUpdate,      //用户设备状态改变回调
    OffcnSmallClassSDKEventEndRoom,        //结束课程回调
    OffcnSmallClassSDKEventVideoStatusDenied,     //没有相机权限回调
    OffcnSmallClassSDKEventAudioStatusDenied,     //没有麦克风权限回调
};

//事件回调返回的数据模型
@interface OffcnSmallClassSDKResponseModel : NSObject

//是否成功
@property (nonatomic,assign) BOOL isSuccess;
//昵称
@property (nonatomic,copy) NSString *nickname;
//uuid
@property (nonatomic,copy) NSString *uuid;
//上台成功返回视频渲染视图
@property (nonatomic,strong) UIView *renderView;

//错误码
@property (nonatomic,assign) NSInteger code;
//返回的错误信息
@property (nonatomic,copy) NSString *errorMessage;

//返回的原内容
@property (nonatomic) id responseObject;

-(instancetype)initWithResponseObject:(id)responseObject;
@end


@protocol OffcnSmallClassSDKDelegate <NSObject>

//事件回调
-(void)offcnSmallClassSDKEvent:(OffcnSmallClassSDKEvent)event responseModel:(OffcnSmallClassSDKResponseModel *)responseModel;

@optional
//音量大小回调
-(void)volumeChangedWithUUID:(NSString *)uuid value:(unsigned short)value;
//视图size变化
-(void)renderViewSizeChangedWithUUID:(NSString *)uuid size:(CGSize)size;
@end


@interface OffcnSmallClassSDK : NSObject

@property(nonatomic, weak) id<OffcnSmallClassSDKDelegate> delegate;

//在线人数
@property (nonatomic, copy) NSString *online_num;
//房间允许最大推流人数
@property (nonatomic, assign) NSInteger max_push;
//所有用户设备状态
@property (nonatomic, strong) NSMutableDictionary *userEquipmentDic;

//创建直播单例服务
+(OffcnSmallClassSDK *)defaultService;

//登陆房间
-(void)loginWithUUID:(NSString *)uuid userName:(NSString *)userName password:(NSString *)password extensionDic:(NSDictionary *)extensionDic;
//退出房间
-(void)leaveRoom;

//加入会话
-(void)join;
//退出会话
-(void)unjoin;

//设置是否默认接收音频流
-(void)setDefaultMuteAllRemoteAudioStreams:(BOOL)mute;
//设置是否默认接收视频流
-(void)setDefaultMuteAllRemoteVideoStreams:(BOOL)mute;

//推流上台
-(void)push;
//断流下台
-(void)unpush;

//订阅指定流
-(void)subWithUUID:(NSString *)uuid;
//解除订阅指定流
-(void)unsubWithUUID:(NSString *)uuid;

//开启视频预览
-(void)startPreview;
//停止视频预览
-(void)stopPreview;
//切换前置、后置摄像头
-(void)switchCamera;

//开,关本地音频采集
-(void)enableLocalAudio:(BOOL)enable;
//停止,恢复发送本地音频流
-(void)muteLocalAudioStream:(BOOL)mute;
//停止,恢复接受指定音频流
-(void)muteRemoteAudioStream:(NSString *)uuid mute:(BOOL)mute;
//停止,接收所有远端音频流
-(void)muteAllRemoteAudioStreams:(BOOL)mute;

//开,关本地视频采集
-(void)enableLocalVideo:(BOOL)enable;
//停止,恢复发送本地视频流
-(void)muteLocalVideoStream:(BOOL)mute;
//停止,恢复接受指定视频流
-(void)muteRemoteVideoStream:(NSString *)uuid mute:(BOOL)mute;
//停止,接收所有远端视频流
-(void)muteAllRemoteVideoStreams:(BOOL)mute;

@end

NS_ASSUME_NONNULL_END
