/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import "ZYJSDWebImage.h"
// This category is just use as a convenience method. For more detail control, use methods in `UIImage+ZYJMultiFormat.h` or directlly use `ZYJSDImageCoder`
@interface UIImage (ZYJWebP)

/**
 Create a image from the WebP data.
 This will create animated image if the data is Animated WebP. And will create a static image is the data is Static WebP.

 @param data The WebP data
 @return The created image
 */
+ (nullable UIImage *)ZYJSD_imageWithWebPData:(nullable NSData *)data;

@end
