/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import "ZYJSDWebImageCompat.h"

#if ZYJSD_MAC

#import "UIImage+ZYJTransform.h"

@interface NSBezierPath (ZYJSDRoundedCorners)

/**
 Convenience way to create a bezier path with the specify rounding corners on macOS. Same as the one on `UIBezierPath`.
 */
+ (nonnull instancetype)ZYJSD_bezierPathWithRoundedRect:(NSRect)rect byRoundingCorners:(ZYJSDRectCorner)corners cornerRadius:(CGFloat)cornerRadius;

@end

#endif
