//
//  OffcnDownloadManager.h
//  OffcnLiveSDK
//
//  Created by vockey on 2019/1/22.
//  Copyright © 2019年 中公教育. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, OffcnDownloadState) {
    OffcnDownloadStateResume = 0,//开始下载或继续下载
    OffcnDownloadStateSuspended,//暂停
    OffcnDownloadStateClean,//清除当前的视频
    OffcnDownloadStateAllClean,//清除所有的视频
    
    OffcnDownloadStateWaiting,//等待
    OffcnDownloadStateProgress,//进度//进行中
    OffcnDownloadStateCompleted,//下载完成
    OffcnDownloadStateFailed,//下载失败
    
    OffcnDownloadStateLocalAlreadyExists,//本地已存在
};

typedef NS_ENUM(NSInteger, OffcnReachabilityStatus) {
    OffcnRealStatusUnknown = -1,
    OffcnRealStatusNotReachable = 0,
    OffcnRealStatusViaWWAN = 1,
    OffcnRealStatusViaWiFi = 2
};

@interface OffcnDownloadManagerModel : NSObject

//沙盒所有视频所在路径
@property (nonatomic, copy) NSString *documentPath;
//沙盒每个下载视频路径
@property (nonatomic, copy) NSString *itemPath;
//沙盒每个下载视频m3u8文件路径
@property (nonatomic, copy) NSString *itemM3U8Path;
//沙盒每个下载视频教室聊天数据库地址
@property (nonatomic, copy) NSString *itemSqlitePath;
//沙盒每个下载视频大厅聊天数据库地址
@property (nonatomic, copy) NSString *lobby_itemSqlitePath;
//沙盒每个下载视频公告数据库地址
@property (nonatomic, copy) NSString *itemGongGaoSqlitePath;

//沙盒在线观看m3u8Path
@property (nonatomic, copy) NSString *zaixian_m3u8Path;

//口令
@property (nonatomic, copy) NSString *password;
//房间名称
@property (nonatomic, copy) NSString *room_name;
//流地址ts全地址
@property (nonatomic, copy) NSString *flowUrlStr;
//流地址ts序号地址
@property (nonatomic, copy) NSString *flowUrlPartStr;

//私钥
@property (nonatomic, copy)NSString *randomStr;
@property (nonatomic, copy)NSString *ts_Str;

//接口返回教室聊天数据库地址
@property (nonatomic, copy) NSString *sqlite;
//接口返回大厅聊天数据库地址
@property (nonatomic, copy) NSString *lobby_timeChat;
//是否转推过：1是，0否
@property (nonatomic, assign) NSInteger is_turn_push;
//接口返回公告数据库地址
@property (nonatomic, copy) NSString *timeAnnounce;

//接口返回在线观看m3u8Path地址
@property (nonatomic, copy) NSString *zaixian_m3u8RtmlStr;

//下载最后的ts片角标
@property (nonatomic, assign) NSInteger index;
//总ts片数据
@property (nonatomic, strong) NSArray *listArr;
//进度
@property (nonatomic, assign) float progress;

//沙盒每个下载完成的视频的本地占用大小
@property (nonatomic, copy) NSString *itemFileSize;

//任务
//@property (nonatomic, strong) NSURLSessionDownloadTask *downloadTask;
//下载状态
@property (nonatomic, assign) OffcnDownloadState downloadState;

//extensionDic 拓展字段
@property (nonatomic, strong) NSDictionary *extensionDic;
//关于鉴权的回调地址
@property (nonatomic, copy) NSString *hook;

//某一个ts片下载失败
@property (nonatomic, assign) NSInteger tsFailedIndex;

@end


@class OffcnDownloadManager;
//下载进度OffcnDownloadStateProgress,完成OffcnDownloadStateCompleted,失败OffcnDownloadStateFailed,暂停OffcnDownloadStateSuspended回调
typedef void(^stateCallBack)(NSString *password,OffcnDownloadState state,OffcnDownloadManager *downloadManager);

//网络监测
typedef void(^reachabilityStatusCallBack)(OffcnReachabilityStatus status);
//下载教室聊天数据库状态
typedef void(^downloadChatDatabaseCallBack)(BOOL isSuccess, NSError *error);
//下载大厅聊天数据库状态
typedef void(^downloadHallChatDatabaseCallBack)(BOOL isSuccess, NSError *error);
//下载公告数据库状态
typedef void(^downloadGongGaoDatabaseCallBack)(BOOL isSuccess, NSError *error);

//下载m3u8状态
typedef void(^downloadM3u8CallBack)(BOOL isSuccess, NSError *error);


@interface OffcnDownloadManager : NSObject

//队列集合
@property (nonatomic, strong) NSMutableDictionary *blockOperationDic;
//任务集合
@property (nonatomic, strong) NSMutableDictionary *downloadTaskDic;


//沙盒所有视频所在路径
@property (nonatomic, copy) NSString *documentPath;
//实时下载数据
@property (nonatomic, strong) NSMutableDictionary *modelDic;


//下载进度OffcnDownloadStateProgress,完成OffcnDownloadStateCompleted,失败OffcnDownloadStateFailed,暂停OffcnDownloadStateSuspended回调
@property (nonatomic, copy) stateCallBack downloadStateCallBack;

//网络监测到使用手机流量提醒回调
@property (nonatomic, copy) reachabilityStatusCallBack reachabilitystatusCallBack;
//下载教室聊天数据库状态
@property (nonatomic, copy) downloadChatDatabaseCallBack downloadchatDatabaseCallBack;
//下载大厅聊天数据库状态
@property (nonatomic, copy) downloadHallChatDatabaseCallBack downloadHallchatDatabaseCallBack;

//下载公告数据库状态
@property (nonatomic, copy) downloadGongGaoDatabaseCallBack downloadgonggaoDatabaseCallBack;

//下载M3u8状态
@property (nonatomic, copy) downloadM3u8CallBack downloadm3u8CallBack;

/**
 创建单例

 @return 单例
 */
+ (instancetype)sharedInstance;

@property (nonatomic, assign) NSInteger maxOperationCount;

/**
 下载
 @param password 不同课程的学生口令
 @param hook 根据自己需求区分(直播，回放，下载)的鉴权(OffcnDownloadStateResume开始下载或继续下载时传入)，非必填
 @param documentPath 需要下载的沙盒路径
 @param downloadState 操作事件枚举
 @param extensionDic 根据自己需求的拓展字段，非必填
 */
- (void)downloadDataWithPassword:(NSString *)password hook:(NSString *)hook documentPath:(NSString *)documentPath downloadState:(OffcnDownloadState)downloadState extensionDic:(NSDictionary *)extensionDic;

//时间yyyy-MM-dd
-(NSString*)getAllCurrentTimes;
// 视频列表路径
- (NSString *)videoPathWithModel:(OffcnDownloadManagerModel *)model;
/**
 在线看回放只下载教室聊天数据库
 
 @param model model
 */
- (void)downloadChatDatabaseWithModel:(OffcnDownloadManagerModel *)model;

/**
 在线看回放只下载大厅聊天数据库
 
 @param model model
 */
- (void)downloadHallChatDatabaseWithModel:(OffcnDownloadManagerModel *)model;

/**
在线看回放只下载公告数据库

@param model model
*/
- (void)downloadGonghGaoDatabaseWithModel:(OffcnDownloadManagerModel *)model;

//下载m3u8文件
- (void)downloadM3u8WithModel:(OffcnDownloadManagerModel *)model;
@end
