/*
   offcn Whiteboard
 */

#import <UIKit/UIKit.h>
#import "WhiteboardType.h"

@protocol WhiteboardEventDelegate <NSObject>

-(void)whiteboardEentCallback:(WhiteboardEventType) eventType param1:(int64_t)param1 param2:(int64_t) param2 data:(NSData*)data;

-(void)whiteboardLostIndexCallback:(int)seq handle:(int64_t)handle;
-(void)whiteboardLostPageCallback:(NSString*)pageID handle:(int64_t)handle;

@end

typedef struct WBPoint{
    int x;
    int y;
}WBPoint;

@interface WhiteboardGLView : UIView


- (id) initWithFrame:(CGRect)frame playMode:(WhiteboardPlayerMode)playMode delegate:(id<WhiteboardEventDelegate>)delegate;

- (void)initWhiteboard:(id<WhiteboardEventDelegate>)delegate;
- (void)destroyWhiteboard;
- (BOOL)enableWhiteboard:(NSString*)imagePath;
- (BOOL)setEntityType:(WhiteboardEntityType)type;

-(WhiteboardPlayerMode)getCurrentPlayMode;

- (BOOL)whiteboardOpen:(NSData*)info;
- (BOOL)whiteboardLoad:(NSData*)pkt;

-(BOOL)closePrePage:(int64_t)handle;

- (BOOL)setMotionType:(WhiteboardMotionType)type;
//- (BOOL)resize:(int)width height:(int)height;

//start
-(BOOL)motionStart:(CGPoint)point;
-(BOOL)motionMove:(CGPoint)point;
-(BOOL)motionStop:(CGPoint)point;

-(BOOL)setEntityColor:(int)color;
-(BOOL)setEntityLineThickness:(float)thickness;
-(BOOL)setEntityFillType:(WhiteboardPaintStyle)type;

-(BOOL)setText:(int64_t)handle text:(NSString*)text;
-(BOOL)setFont:(NSString*)fontPath;
-(BOOL)createImage:(NSString*)localPath url:(NSString*)url;
-(BOOL)insertImage:(int64_t)handle path:(NSString*)path;

-(BOOL)createCanvas:(NSString*)imagePath;
-(BOOL)headCanvas;
-(BOOL)tailCanvas;
-(BOOL)nextCanvas;
-(BOOL)prevCanvas;
-(BOOL)deleteCanvas;
-(BOOL)clearCanvas;

-(BOOL)redraw;
-(BOOL)draw;
-(void)resize;
-(BOOL)clearWhiteboardData;

-(BOOL)setTextAction:(int64_t)handle action:(int)action;
-(BOOL)setTextCursor:(int64_t)handle cursorType:(int)cursorType;
-(BOOL)setFontColor:(int64_t)handle fontColor:(int)fontColor;
-(BOOL)setFontSize:(int64_t)handle fontSize:(float)fontSize;
-(BOOL)setFontStyle:(int64_t)handle fontStyle:(int)fontStyle;

-(NSString*)getImageUrl:(int64_t)handle;

-(BOOL)setViewScale:(float)scale isOptimize:(BOOL)isOptimize;
-(float)getViewScale;
-(BOOL)setViewScaleCenterPoint:(WBPoint)point;
-(WBPoint)getViewScrollPoint;
-(BOOL)setViewScrollPoint:(WBPoint)point isOptimize:(BOOL)isOptimize;
-(WBPoint)getViewScrollRange;

-(BOOL)pushWhiteboardDataFromPlayer:(NSData*)data;
-(BOOL)pushWhiteboardDataFromFile:(NSString*)filePath operationSeq:(int)operationSeq;
-(BOOL)pushWhiteboardDataFromFileWithHandle:(NSString*)filePath operationSeq:(int)operationSeq handle:(int64_t)handle;
@property(nonatomic)        CGFloat  scaleFactor;
@property(weak,nonatomic) id<WhiteboardEventDelegate> eventDelegate;

@end
