/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 * (c) Fabrice Aneche
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import <Foundation/Foundation.h>
#import "ZYJSDWebImageCompat.h"

/**
 You can use switch case like normal enum. It's also recommended to add a default case. You should not assume anything about the raw value.
 For custom coder plugin, it can also extern the enum for supported format. See `ZYJSDImageCoder` for more detailed information.
 */
typedef NSInteger ZYJSDImageFormat NS_TYPED_EXTENSIBLE_ENUM;
static const ZYJSDImageFormat ZYJSDImageFormatUndefined = -1;
static const ZYJSDImageFormat ZYJSDImageFormatJPEG      = 0;
static const ZYJSDImageFormat ZYJSDImageFormatPNG       = 1;
static const ZYJSDImageFormat ZYJSDImageFormatGIF       = 2;
static const ZYJSDImageFormat ZYJSDImageFormatTIFF      = 3;
static const ZYJSDImageFormat ZYJSDImageFormatWebP      = 4;
static const ZYJSDImageFormat ZYJSDImageFormatHEIC      = 5;
static const ZYJSDImageFormat ZYJSDImageFormatHEIF      = 6;
static const ZYJSDImageFormat ZYJSDImageFormatPDF       = 7;
static const ZYJSDImageFormat ZYJSDImageFormatSVG       = 8;

/**
 NSData category about the image content type and UTI.
 */
@interface NSData (ZYJImageContentType)

/**
 *  Return image format
 *
 *  @param data the input image data
 *
 *  @return the image format as `ZYJSDImageFormat` (enum)
 */
+ (ZYJSDImageFormat)ZYJSD_imageFormatForImageData:(nullable NSData *)data;

/**
 *  Convert ZYJSDImageFormat to UTType
 *
 *  @param format Format as ZYJSDImageFormat
 *  @return The UTType as CFStringRef
 *  @note For unknown format, `kUTTypeImage` abstract type will return
 */
+ (nonnull CFStringRef)ZYJSD_UTTypeFromImageFormat:(ZYJSDImageFormat)format CF_RETURNS_NOT_RETAINED NS_SWIFT_NAME(ZYJSD_UTType(from:));

/**
 *  Convert UTType to ZYJSDImageFormat
 *
 *  @param uttype The UTType as CFStringRef
 *  @return The Format as ZYJSDImageFormat
 *  @note For unknown type, `ZYJSDImageFormatUndefined` will return
 */
+ (ZYJSDImageFormat)ZYJSD_imageFormatFromUTType:(nonnull CFStringRef)uttype;

@end
