/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import <Foundation/Foundation.h>
#import "ZYJSDImageIOAnimatedCoder.h"

/**
 Built in coder using ImageIO that supports animated GIF encoding/decoding
 @note `ZYJSDImageIOCoder` supports GIF but only as static (will use the 1st frame).
 @note Use `ZYJSDImageGIFCoder` for fully animated GIFs. For `UIImageView`, it will produce animated `UIImage`(`NSImage` on macOS) for rendering. For `ZYJSDAnimatedImageView`, it will use `ZYJSDAnimatedImage` for rendering.
 @note The recommended approach for animated GIFs is using `ZYJSDAnimatedImage` with `ZYJSDAnimatedImageView`. It's more performant than `UIImageView` for GIF displaying(especially on memory usage)
 */
@interface ZYJSDImageGIFCoder : ZYJSDImageIOAnimatedCoder <ZYJSDProgressiveImageCoder, ZYJSDAnimatedImageCoder>

@property (nonatomic, class, readonly, nonnull) ZYJSDImageGIFCoder *sharedCoder;

@end
