/*
 *  Copyright 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#import "RTCMacros.h"
#import <Foundation/Foundation.h>


NS_ASSUME_NONNULL_BEGIN


@protocol RTCAudioSinkDelegate <NSObject>

@optional
- (void)onVolume:(NSString*)handleID sinkVolume:(unsigned short)volume;
@end

@interface RTCAudioSink : NSObject

//@property (readwrite, nonatomic)  unsigned short sinkVolume;

-(void)setVolume:(unsigned short)volume;

@property(nonatomic, weak) id<RTCAudioSinkDelegate> delegate;

@property (readwrite, nonatomic) NSString* handleID;
@end

NS_ASSUME_NONNULL_END
