//
//  iOSViewController.m
//  OffcnLiveSDK
//
//  Created by vockey on 2018/7/25.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "iOSViewController.h"
#import "OffcnLiveSDK.h"

@interface iOSViewController ()<UITextFieldDelegate>

@property (weak, nonatomic) IBOutlet UITextField *nameTextField;

@property (weak, nonatomic) IBOutlet UITextField *koulingTextField;

@property (weak, nonatomic) IBOutlet UITextField *uuidTextField;

@property (weak, nonatomic) IBOutlet UIButton *enterRoomBtn;

@property (weak, nonatomic) IBOutlet UIButton *playBackBtn;

@end

@implementation iOSViewController

#pragma mark - 直播事件
- (IBAction)enterRoomAction:(UIButton *)sender {
    
    [self.view endEditing:YES];

    [[OffcnLiveSDK defaultService] authWithNavigationController:self.navigationController VideoType:OffcnVideoTypeBigClassLive jumpMode:OffcnJumpModePush appName:@"zaixianketang" phone:@"18310564002" nickname:self.nameTextField.text password:self.koulingTextField.text uuid:self.uuidTextField.text hook:@"123" documentPath:@"123" extensionDic:[NSDictionary dictionaryWithObject:@"123" forKey:@"123"] playbackSeekTime:0];
    
//更换某个控件颜色
//        NSString *colorStr = @"#ff895f";
//        [OffcnLiveSDK defaultService].tabNormalColor(colorStr).tabSelectedColor(colorStr).chatBgColor(colorStr).chatNicknameColor(@"#ffffff").inputBgColor(colorStr).roomInfoBgColor(colorStr).roomInfoTitleColor(colorStr).roomOnlineNumColor(colorStr).wbTitleColor(colorStr).liveLabelBgColor(@"#ffffff").liveLabelTitleColor(colorStr);
}

#pragma mark - 回放视频事件
- (IBAction)playBackAction:(UIButton *)sender {
    [[OffcnLiveSDK defaultService] authWithNavigationController:self.navigationController VideoType:OffcnVideoTypeBigClassPlayback jumpMode:OffcnJumpModePush appName:@"zaixianketang" phone:@"18310564002" nickname:self.nameTextField.text password:self.koulingTextField.text uuid:self.uuidTextField.text hook:@"123" documentPath:@"123" extensionDic:[NSDictionary dictionaryWithObject:@"123" forKey:@"123"] playbackSeekTime:0];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.nameTextField.text = @"杜拉拉";
    self.koulingTextField.text = @"q6qbmnox3cy";
    self.uuidTextField.text = [NSString stringWithFormat:@"%d",arc4random_uniform(1000000)];
    
    self.nameTextField.delegate = self;
    self.koulingTextField.delegate = self;
    self.uuidTextField.delegate = self;
    [self.nameTextField addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
    [self.koulingTextField addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
    [self.uuidTextField addTarget:self action:@selector(textFieldDidChange:) forControlEvents:UIControlEventEditingChanged];
    if (self.nameTextField.text.length && self.koulingTextField.text.length && self.uuidTextField.text.length) {
        
        self.enterRoomBtn.enabled = YES;
        self.playBackBtn.enabled = YES;
    }else{
        self.enterRoomBtn.enabled = NO;
        self.playBackBtn.enabled = NO;
    }
}

#pragma mark - UITextField代理
-(void)textFieldDidChange:(UITextField *)textField{
    
    if (self.nameTextField.text.length && self.koulingTextField.text.length && self.uuidTextField.text.length) {
        
        self.enterRoomBtn.enabled = YES;
        self.playBackBtn.enabled = YES;
    }else{
        self.enterRoomBtn.enabled = NO;
        self.playBackBtn.enabled = NO;
    }
}

- (BOOL)textFieldShouldClear:(UITextField *)textField{
    
    self.enterRoomBtn.enabled = NO;
    self.playBackBtn.enabled = NO;
    return YES;
}

-(void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event{
    [self.view endEditing:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
@end
