//
//  iOSAppDelegate.m
//  OffcnLiveSDK
//
//  Created by zhangyunjie on 07/26/2018.
//  Copyright (c) 2018 zhangyunjie. All rights reserved.
//

#import "iOSAppDelegate.h"
#import "iOSViewController.h"
#import "OffcnLiveSDK.h"

@implementation iOSAppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    self.window = [[UIWindow alloc]initWithFrame:[UIScreen mainScreen].bounds];
    UINavigationController *mainVC = [[UINavigationController alloc] initWithRootViewController:[[UIStoryboard storyboardWithName:@"Main" bundle:nil] instantiateInitialViewController]];
    mainVC.navigationBar.translucent = NO;
    self.window.rootViewController = mainVC;
    
    self.window.backgroundColor = [UIColor whiteColor];
    
    [self.window makeKeyAndVisible];
    
    //启动SDK
    [[OffcnLiveSDK defaultService] setupWithAppUrlSchemes:@"" imageType:OffcnImageType_e60012 buttonType:OffcnButtonTypeRadius isTest:YES eventCallBack:^(OffcnSDKEvent event, OffcnSDKEventLookCourseModel *lookCourseModel, OffcnSDKEventWechatAppletModel *wechatAppletModel) {
        
        if (event == OffcnSDKEventLookCourse) {
            //已购买商品触发事件去听课页查看课程
            NSLog(@"OffcnSDKEventLookCourse:%lu;sn:%@",(unsigned long)event,lookCourseModel.sn);
        }else if (event == OffcnSDKEventWechatApplet){
            //跳转微信小程序事件
            NSLog(@"OffcnSDKEventWechatApplet:%lu;urlString:%@;goodIDStr:%@",(unsigned long)event,wechatAppletModel.urlString,wechatAppletModel.goodIDStr);
        }
    }];
    
    
//    [OffcnLiveSDK defaultService].offcnGoodsCartStatus = OffcnGoodsCartStatusHid;//购物车是否显示
//    [OffcnLiveSDK defaultService].offcnSDKClickGoodsCartCallBack = ^(NSString *roomid) {
//        //点击购物车事件
//    };
    
    
    
//    [OffcnLiveSDK defaultService].isShowSendGifts = YES;//是否展示送礼物入口
//
//    //获取送礼物信息事件
//    [OffcnLiveSDK defaultService].getGiftInfoCallBack = ^{
//        [OffcnLiveSDK defaultService].product = @"0";//应用id 0中公教育 1 在线课堂 默认0
//        [OffcnLiveSDK defaultService].u_head = @"";//登录用户头像链接地址
//        [OffcnLiveSDK defaultService].surplus = @"100";//账户余额
//        [OffcnLiveSDK defaultService].rechargeAgreement = @"https://www.eoffcn.com/help/agreements/offcncoin_user_agreement.html";//充值协议
//
//
//        NSMutableArray *modelArr = [NSMutableArray array];
//        OffcnSDKEventBeansMoneyModel *chooseMoneyModel = [[OffcnSDKEventBeansMoneyModel alloc] init];
//        chooseMoneyModel.num = @"7";
//        chooseMoneyModel.price = @"1";
//        [modelArr addObject:chooseMoneyModel];
//
//        OffcnSDKEventBeansMoneyModel *chooseMoneyModel1 = [[OffcnSDKEventBeansMoneyModel alloc] init];
//        chooseMoneyModel1.num = @"42";
//        chooseMoneyModel1.price = @"6";
//        [modelArr addObject:chooseMoneyModel1];
//
//        [OffcnLiveSDK defaultService].beansMoneyModelArr = modelArr;//充值豆规格
//    };
//
//    //立即充值事件
//    [OffcnLiveSDK defaultService].rechargeCallBack = ^(OffcnSDKEventBeansMoneyModel *beanModel) {
//
//    };

    
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    if([OffcnLiveSDK defaultService].isFull){
        
        return UIInterfaceOrientationMaskAllButUpsideDown;
    }
    return UIInterfaceOrientationMaskPortrait;
}
@end
