#import <Foundation/Foundation.h>
#import "WebRTC.h"
#import "RTCMacros.h"

#define USER_LOCAL @"local"
#define USER_REMOTE @"remote"
static const char *ZGWebrtcVersion = "0.1.20";

@protocol P2PFactoryDelegate <NSObject>
- (void)onCreateView:(RTCEAGLVideoView*)view
              type:(NSString*)userType;

- (void)onCreateSdp:(NSString*)type
            sdp:(RTCSessionDescription *)sdp;

- (void)onCreateCandidate:(RTCIceCandidate *)candidate;
- (void)onCreateRemoteUser:(NSString *)userID;

@optional
- (void)onViewSizeChanged:(RTCEAGLVideoView *)videoView streamID:(NSString*)streamID didChangeVideoSize:(CGSize)size;
- (void)onVolumeChanged:(NSString*)userID didChangeVolume:(unsigned short)volume;
- (void)onIceState:(RTCIceConnectionState)state userID:(NSString *)userID streamID:(NSString*)streamID clientType:(ClientType)clientType;
- (void)onOpenCameraFailed;
- (void)onSendStats:(RTCMediaStats *)stats;
- (void)onRecieveStats:(RTCMediaStats *)stats;
- (void)onLogOut:(NSString *)logInfo;
- (void)onSnapshot:(UIImage*)snapshot;
@end

@interface P2PFactory : NSObject <RTCPeerConnectionDelegate,RTCVideoViewDelegate,RTCAudioSinkDelegate>

- (instancetype)init;

@property(nonatomic, weak) id<P2PFactoryDelegate> delegate;

@property(nonatomic, copy) NSString* remoteUserID;
/**
 创建推流用户

 @param userID 推流用户ID
 */
- (void)setPublisher:(NSString *)userID isCalled:(BOOL)bCalled;

/**
 推流用户设置服务器sdp
 @param jsep 远程服务器sdp信息
 */
- (void)setRemoteAnswer:(NSDictionary *)jsep;

/**
  订阅用户设置远程推流用户

 @param userID 远程用户ID
 */
- (void)setRemoteCall: (NSString *)userID;

/**
 订阅用户设置远程sdp

 @param jsep 远程sdp
 */
- (void)setRemoteOffer:(NSDictionary *)jsep;

/**
 订阅用户设置远程candidate

 @param candidate 远程candidate
 */
- (void)setRemoteCandidate:(NSDictionary *)candidate;

/**
 停止本地推流
 */
- (void)stopPublish;

/**
 切换摄像头
 */
- (void)switchCamera;

/**
 播放
 */
- (void)play;

/**
 暂停
 */
- (void)pause;

/**
 关闭连麦
 */
- (void)close;

/**
 开启关闭日志功能 true打开，false 关闭
 */

-(void)logOutput:(BOOL)logEnable;

@end

