/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import <Foundation/Foundation.h>
#import <os/lock.h>
#import <libkern/OSAtomic.h>
#import "ZYJSDmetamacros.h"

#define ZYJSD_USE_OS_UNFAIR_LOCK TARGET_OS_MACCATALYST ||\
    (__IPHONE_OS_VERSION_MIN_REQUIRED >= __IPHONE_10_0) ||\
    (__MAC_OS_X_VERSION_MIN_REQUIRED >= __MAC_10_12) ||\
    (__TV_OS_VERSION_MIN_REQUIRED >= __TVOS_10_0) ||\
    (__WATCH_OS_VERSION_MIN_REQUIRED >= __WATCHOS_3_0)

#ifndef ZYJSD_LOCK_DECLARE
#if ZYJSD_USE_OS_UNFAIR_LOCK
#define ZYJSD_LOCK_DECLARE(lock) os_unfair_lock lock
#else
#define ZYJSD_LOCK_DECLARE(lock) os_unfair_lock lock API_AVAILABLE(ios(10.0), tvos(10), watchos(3), macos(10.12)); \
OSSpinLock lock##_deprecated;
#endif
#endif

#ifndef ZYJSD_LOCK_DECLARE_STATIC
#if ZYJSD_USE_OS_UNFAIR_LOCK
#define ZYJSD_LOCK_DECLARE_STATIC(lock) static os_unfair_lock lock
#else
#define ZYJSD_LOCK_DECLARE_STATIC(lock) static os_unfair_lock lock API_AVAILABLE(ios(10.0), tvos(10), watchos(3), macos(10.12)); \
static OSSpinLock lock##_deprecated;
#endif
#endif

#ifndef ZYJSD_LOCK_INIT
#if ZYJSD_USE_OS_UNFAIR_LOCK
#define ZYJSD_LOCK_INIT(lock) lock = OS_UNFAIR_LOCK_INIT
#else
#define ZYJSD_LOCK_INIT(lock) if (@available(iOS 10, tvOS 10, watchOS 3, macOS 10.12, *)) lock = OS_UNFAIR_LOCK_INIT; \
else lock##_deprecated = OS_SPINLOCK_INIT;
#endif
#endif

#ifndef ZYJSD_LOCK
#if ZYJSD_USE_OS_UNFAIR_LOCK
#define ZYJSD_LOCK(lock) os_unfair_lock_lock(&lock)
#else
#define ZYJSD_LOCK(lock) if (@available(iOS 10, tvOS 10, watchOS 3, macOS 10.12, *)) os_unfair_lock_lock(&lock); \
else OSSpinLockLock(&lock##_deprecated);
#endif
#endif

#ifndef ZYJSD_UNLOCK
#if ZYJSD_USE_OS_UNFAIR_LOCK
#define ZYJSD_UNLOCK(lock) os_unfair_lock_unlock(&lock)
#else
#define ZYJSD_UNLOCK(lock) if (@available(iOS 10, tvOS 10, watchOS 3, macOS 10.12, *)) os_unfair_lock_unlock(&lock); \
else OSSpinLockUnlock(&lock##_deprecated);
#endif
#endif

#ifndef ZYJSD_OPTIONS_CONTAINS
#define ZYJSD_OPTIONS_CONTAINS(options, value) (((options) & (value)) == (value))
#endif

#ifndef ZYJSD_CSTRING
#define ZYJSD_CSTRING(str) #str
#endif

#ifndef ZYJSD_NSSTRING
#define ZYJSD_NSSTRING(str) @(ZYJSD_CSTRING(str))
#endif

#ifndef ZYJSD_SEL_SPI
#define ZYJSD_SEL_SPI(name) NSSelectorFromString([NSString stringWithFormat:@"_%@", ZYJSD_NSSTRING(name)])
#endif

#ifndef weakify
#define weakify(...) \
ZYJSD_keywordify \
metamacro_foreach_cxt(ZYJSD_weakify_,, __weak, __VA_ARGS__)
#endif

#ifndef strongify
#define strongify(...) \
ZYJSD_keywordify \
_Pragma("clang diagnostic push") \
_Pragma("clang diagnostic ignored \"-Wshadow\"") \
metamacro_foreach(ZYJSD_strongify_,, __VA_ARGS__) \
_Pragma("clang diagnostic pop")
#endif

#define ZYJSD_weakify_(INDEX, CONTEXT, VAR) \
CONTEXT __typeof__(VAR) metamacro_concat(VAR, _weak_) = (VAR);

#define ZYJSD_strongify_(INDEX, VAR) \
__strong __typeof__(VAR) VAR = metamacro_concat(VAR, _weak_);

#if DEBUG
#define ZYJSD_keywordify autoreleasepool {}
#else
#define ZYJSD_keywordify try {} @catch (...) {}
#endif

#ifndef onExit
#define onExit \
ZYJSD_keywordify \
__strong ZYJSD_cleanupBlock_t metamacro_concat(ZYJSD_exitBlock_, __LINE__) __attribute__((cleanup(ZYJSD_executeCleanupBlock), unused)) = ^
#endif

typedef void (^ZYJSD_cleanupBlock_t)(void);

#if defined(__cplusplus)
extern "C" {
#endif
    void ZYJSD_executeCleanupBlock (__strong ZYJSD_cleanupBlock_t *block);
#if defined(__cplusplus)
}
#endif
