/*
 * This file is part of the ZYJSDWebImage package.
 * (c) Olivier Poitrey <rs@dailymotion.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

#import "ZYJSDWebImageCompat.h"

@class ZYJSDAsyncBlockOperation;
typedef void (^ZYJSDAsyncBlock)(ZYJSDAsyncBlockOperation * __nonnull asyncOperation);

/// A async block operation, success after you call `completer` (not like `NSBlockOperation` which is for sync block, success on return)
@interface ZYJSDAsyncBlockOperation : NSOperation

- (nonnull instancetype)initWithBlock:(nonnull ZYJSDAsyncBlock)block;
+ (nonnull instancetype)blockOperationWithBlock:(nonnull ZYJSDAsyncBlock)block;
- (void)complete;

@end
