//
//  OffcnVideoView.h
//  OffcnLiveSDK
//
//  Created by vockey on 2020/7/16.
//  Copyright © 2020 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef void(^recentlyWatchCallBack)(NSInteger recentlyWatchValue, NSInteger totalValue);

//窗口旋转回调
typedef void(^windowRotationCallBack)(UIInterfaceOrientation interfaceOrientation);

@interface OffcnVideoView : UIView

@property (nonatomic, assign) BOOL isDefaultPlay;//默认是否播放

@property (nonatomic, assign) BOOL isHiddenReturnBtn;//是否隐藏返回按钮

@property (nonatomic, assign) BOOL isHiddenTitle;//是否隐藏标题

@property (nonatomic, assign) BOOL isHiddenNavTool;//是否隐藏顶部工具栏

@property (nonatomic, assign) BOOL isHiddenTabTool;//是否隐藏底部工具栏

//回放开始的时间，单位：秒，默认从0秒开始，根据需求是否从上次观看记录的位置开始播放，如果没有上次观看记录的位置请传0
@property (nonatomic, assign) NSTimeInterval seekTime;

@property (nonatomic, copy) NSString *titleStr;//标题

@property (nonatomic, assign) BOOL isMusic;//是否纯音乐类型，例如MP4
@property (nonatomic, strong) UIImageView *musicImage;//播放音乐背景

//设置播放地址和解密密HLS需要的Key
@property (nonatomic, copy) NSString *rtmlStr;//播放地址
@property (nonatomic, copy) NSString *keyStr;//没有加密的视频不用传

@property (nonatomic, copy) recentlyWatchCallBack recentlyWatchCallBack;//回放观看进度回调

@property (nonatomic, copy) void(^returnBtnActionCallBack)(UIInterfaceOrientation interfaceOrientation, NSInteger recentlyWatchValue, NSInteger totalValue);//返回按钮回调


//暂不支持
@property (nonatomic, assign) UIInterfaceOrientation interfaceOrientation;//竖横屏

@property (nonatomic, copy) windowRotationCallBack windowRotationCallBack;//窗口旋转回调
@end






