//
//  OffcnLiveSDK.h
//  OffcnLiveSDK
//
//  Created by vockey on 2018/10/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnShareWindow.h"

static const NSString *OffcnLiveSDKVersion = @"2.7.7.2";

//事件通知
#define kOffcnSDKEventLookCourseNotification @"kOffcnSDKEventLookCourseNotification"

@interface OffcnPlaybackModel : NSObject
//口令
@property (nonatomic, copy) NSString *password;
//是否在线播放
@property (nonatomic, assign) BOOL isOnline;
//当前播放时间
@property (nonatomic, assign) NSInteger currentSeconds;
//视频总时长
@property (nonatomic, assign) NSInteger totalSeconds;
@end

@interface OffcnSDKEventLookCourseModel : NSObject

@property (nonatomic,copy) NSString *spuId;//商品spuId
@property (nonatomic,copy) NSString *goodsName;//商品名字
@property (nonatomic,copy) NSString *sn;//系统单号
@end

@interface OffcnSDKEventWechatAppletModel : NSObject

@property (nonatomic,copy) NSString *urlString;//url地址
@property (nonatomic,copy) NSString *goodIDStr;//商品ID，目前只返回@"0"
@end





typedef NS_ENUM(NSUInteger, OffcnImageType) {
    OffcnImageTypeDefault = 1, //默认
    OffcnImageTypeBeiDa,         //北大主色调#9b0000适配图片
    OffcnImageType_e60012,       //主色调#e60012适配图片
};
typedef NS_ENUM(NSUInteger, OffcnButtonType) {
    OffcnButtonTypeDefault = 1, //默认
    OffcnButtonTypeRadius,      //定制
};

typedef NS_ENUM(NSUInteger, OffcnVideoType) {
    OffcnVideoTypeBigClassLive = 1,       //大班课直播
    OffcnVideoTypeBigClassPlayback,       //大班课回放
    OffcnVideoTypeSmallClassLive,         //小班课直播
    OffcnVideoTypeSmallClassPlayback,     //小班课回放
};

typedef NS_ENUM(NSUInteger, OffcnJumpMode) {
    OffcnJumpModePush = 0,
    OffcnJumpModePresent,
};

typedef NS_ENUM(NSUInteger, OffcnSDKReachabilityStatus) {
    OffcnSDKReachabilityStatusNotReachable = 0,
    OffcnSDKReachabilityStatusViaWWAN,
    OffcnSDKReachabilityStatusViaWiFi,
};

typedef NS_ENUM(NSUInteger, OffcnSDKEvent) {
    OffcnSDKEventLookCourse = 1, //已购买商品触发事件去听课页查看课程
    OffcnSDKEventWechatApplet = 2, //跳转微信小程序事件
};

//直播间退出房间后回调
typedef void(^liveQuitCallBack)(NSString *password);

/**
回放观看进度退出房间后回调

@param password 课程口令
@param recentlyWatchValue 最近观看的秒数
@param maxWatchValue 最大观看的进度（最大观看的秒数/总时长秒数所得值）
@param totalValue 总时长秒数
*/
typedef void(^playbackCallBack)(NSString *password, NSInteger recentlyWatchValue, CGFloat maxWatchValue, NSInteger totalValue);

//网络监听回调
typedef void(^OffcnSDKReachabilityStatusCallBack)(OffcnSDKReachabilityStatus status);

/**
 事件回调
 @param event 事件类型
 @param lookCourseModel 已购买商品触发事件去听课页查看课程Model,仅限事件OffcnSDKEventLookCourse使用
 @param wechatAppletModel 跳转微信小程序Model,仅限事件OffcnSDKEventWechatApplet使用
 */
typedef void(^OffcnSDKEventCallBack)(OffcnSDKEvent event,OffcnSDKEventLookCourseModel *lookCourseModel,OffcnSDKEventWechatAppletModel *wechatAppletModel);

@interface OffcnLiveSDK : NSObject

/**
 创建直播单例服务

 @return 返回单例对象
 */
+ (OffcnLiveSDK *)defaultService;

//共享窗口
@property (nonatomic, strong) OffcnShareWindow *shareWindow;
@property (nonatomic, assign) BOOL isSmallWindow;
@property (nonatomic, assign) CGRect shareWindowFrame;
@property (nonatomic, strong) UIWindow *KKeyWindow;//获取自定义window
@property (nonatomic, strong) UIWindow *oldKKeyWindow;//三方的window
@property (nonatomic, weak) UIViewController *shareVC;

//app端传过来的ssoAPPId和token
@property (nonatomic, strong) NSString *ssoAppId;
@property (nonatomic, strong) NSString *ssoToken;
@property (nonatomic, strong) NSString *ssoId;
@property (nonatomic, strong) NSString *bc_id;//业务班id


//是否支持全屏
@property (nonatomic, assign) BOOL isFull;

@property (nonatomic, assign) OffcnVideoType videoType;

//直播间退出房间后回调
@property (nonatomic, copy) liveQuitCallBack offcnLiveQuitCallBack;

//回放观看进度退出房间后回调
@property (nonatomic, copy) playbackCallBack offcnPlaybackCallBack;

//回放观看过程中进度model(只在观看过程中有数据，退出房间后就被清空了)
@property (nonatomic, strong) OffcnPlaybackModel *playbackModel;

@property (nonatomic, assign) OffcnSDKReachabilityStatus OffcnReachabilityStatus;
@property (nonatomic, copy) OffcnSDKReachabilityStatusCallBack reachabilityStatusCallBack;

//是否选用测试环境
@property (nonatomic, assign) BOOL isTest;
//选用图片类型
@property (nonatomic, assign) OffcnImageType imageType;
//选用按钮类型
@property (nonatomic, assign) OffcnButtonType buttonType;
//设置选中颜色,例如#9b0000
-(void)colorWithCustomColorStr:(NSString *)colorStr alpha:(CGFloat)alpha;


/// 启动sdk
/// @param appUrlSchemes app设置的UrlSchemes
/// @param imageType 主色调类型
/// @param buttonType 按钮样式
/// @param isTest 是否选用测试环境
/// @param callBack 事件回调
-(void)setupWithAppUrlSchemes:(NSString *)appUrlSchemes imageType:(OffcnImageType)imageType buttonType:(OffcnButtonType)buttonType isTest:(BOOL)isTest eventCallBack:(OffcnSDKEventCallBack)callBack;

/**
 登录授权
 @param navigationController 导航控制器
 @param videoType 观看模式是：大班课直播/大班课回放/小班课直播(注:小班课目前只传OffcnVideoTypeSmallClassLive)
 @param jumpMode 跳转方式：Push/Present(注:小班课只传OffcnJumpModePresent)
 @param appName 支付需要的UA-Name
 @param phone 手机号
 @param nickname 昵称
 @param password 不同课程的学生口令
 @param uuid 用户唯一标识码
 @param hook 根据自己需求区分(直播，回放，下载)的鉴权，非必填
 @param documentPath 沙盒所有视频所在路径
 @param extensionDic 根据自己需求的拓展字段，非必填
 @param seekTime 回放开始的时间，单位：秒，默认从0秒开始，根据需求是否从上次观看记录的位置开始播放，如果没有上次观看记录的位置请传0
 @param ssoAppId  APP的ssoAppId(注：只为教务系统提供，其他三方app传空@"")
 @param ssoToken  登录后返回的用户ssoToken(注：只为教务系统提供，其他三方app传空@"")
 @param bc_id  业务班id(注：只为教务系统提供，其他三方app传空@"")
 */
-(void)authWithNavigationController:(UINavigationController *)navigationController
                          VideoType:(OffcnVideoType)videoType
                           jumpMode:(OffcnJumpMode)jumpMode
                            appName:(NSString *)appName
                              phone:(NSString *)phone
                           nickname:(NSString *)nickname
                           password:(NSString *)password
                               uuid:(NSString *)uuid
                               hook:(NSString *)hook
                       documentPath:(NSString *)documentPath
                       extensionDic:(NSDictionary *)extensionDic
                   playbackSeekTime:(NSTimeInterval)seekTime
                           ssoAppId:(NSString *)ssoAppId
                           ssoToken:(NSString *)ssoToken
                              bc_id:(NSString *)bc_id;


-(void)authWithNavigationController:(UINavigationController *)navigationController
                          VideoType:(OffcnVideoType)videoType
                           jumpMode:(OffcnJumpMode)jumpMode
                            appName:(NSString *)appName
                              phone:(NSString *)phone
                           nickname:(NSString *)nickname
                           password:(NSString *)password
                               uuid:(NSString *)uuid
                               hook:(NSString *)hook
                       documentPath:(NSString *)documentPath
                       extensionDic:(NSDictionary *)extensionDic
                   playbackSeekTime:(NSTimeInterval)seekTime;


-(void)authWithNavigationController:(UINavigationController *)navigationController
                          VideoType:(OffcnVideoType)videoType
                           jumpMode:(OffcnJumpMode)jumpMode
                            appName:(NSString *)appName
                              phone:(NSString *)phone
                           nickname:(NSString *)nickname
                           password:(NSString *)password
                               uuid:(NSString *)uuid
                               hook:(NSString *)hook
                       documentPath:(NSString *)documentPath
                       extensionDic:(NSDictionary *)extensionDic;

/**
 *  resignKeyWindow，并还原到上一次的keyWindow
 */
- (void)recoverLastKeyWindow;

//关闭小窗口
-(void)closeShareWindow;

//开启,关闭日志
-(void)setEnableLog:(BOOL)enable;


//*********************注：以下替换颜色接口已废，不再支持*********************

/**
 tab(聊天，提问板，资料)普通颜色
 */
-(OffcnLiveSDK *(^)(NSString *))tabNormalColor;

/**
 tab(聊天，提问板，资料)选中颜色
 */
-(OffcnLiveSDK *(^)(NSString *))tabSelectedColor;

/**
 聊天区域背景色（默认灰色）
 */
-(OffcnLiveSDK *(^)(NSString *))chatBgColor;

/**
 聊天区域用户名颜色
 */
-(OffcnLiveSDK *(^)(NSString *))chatNicknameColor;

/**
 发送窗背景色（默认白色）
 */
-(OffcnLiveSDK *(^)(NSString *))inputBgColor;

/**
 房间标题区域背景色（默认白色）
 */
-(OffcnLiveSDK *(^)(NSString *))roomInfoBgColor;

/**
 房间标题文字颜色
 */
-(OffcnLiveSDK *(^)(NSString *))roomInfoTitleColor;

/**
 在线人数颜色
 */
-(OffcnLiveSDK *(^)(NSString *))roomOnlineNumColor;

/**
 公众号、微博、QQ群文字颜色
 */
-(OffcnLiveSDK *(^)(NSString *))wbTitleColor;

/**
 “直播”标签的背景色
 */
-(OffcnLiveSDK *(^)(NSString *))liveLabelBgColor;

/**
 “直播”标签的字体颜色
 */
-(OffcnLiveSDK *(^)(NSString *))liveLabelTitleColor;
@end
