//
//  RTCLargeFactory.h
//  WebRTC
//
//  Created by offcnPlayer on 2021/11/26.
//  Copyright © 2021 xiaolin zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WebRTC.h"
#import "RTCMacros.h"
NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, RTCMsgType) {
    RTCAPIMsg,
    RTCSDPMsg,
};

typedef NS_ENUM(NSInteger, RTCErrorType) {
    RTCLargePushChannelFailed,
    RTCLargeMessageChannelFailed,
    RTCLargeAllPullChannelFailed,
    RTCLargeInternalChannelFailed,
};

@protocol RTCLargeFactoryProtocol <NSObject>

- (void)onPullStreamSDP:(NSString*)sdp;
- (void)onPushStreamSDP:(NSString*)sdp;
- (void)onLocalPreview:(UIView*)localView;
- (void)onRTCAPIMessage:(NSData*)msg;
//- (void)onRTCSDPMessage:(NSData*)msg;
- (void)onPeerView:(NSString*)peerID peerView:(UIView*)peerView;
- (void)onError:(RTCErrorType)errorType;
@end



@interface RTCLargeFactory : NSObject

//初始化
- (instancetype)initWithDelegate:(id<RTCLargeFactoryProtocol>)delegate;

//开始拉流
- (BOOL)initPullChannel;
//设置拉流sdp
- (void)setPullChannelParams:(NSString*)sdp;
//订阅流
- (void)subscribeStream:(NSData*)streamInfo;
//取消订阅
- (void)unSubscribeStream:(NSString*)streamID;
//开始推流
- (void)initPushChannel;
//设置推流sdp
- (void)setPushChannelParams:(NSString*)sdp;
//结束推流
- (void)stopPushStream;
//结束拉流
- (void)stopPullStream:(NSString*)peerID;
//本地静音开关
- (void)muteLocalAudioStream:(BOOL)mute;
//本地视频开关
- (void)muteLoacalVideoStream:(BOOL)mute;
//销毁关闭通道
- (void)shutdown;
//发送消息
- (void)sendMsg:(NSData*)msg msgType:(RTCMsgType)msgType;
@end

NS_ASSUME_NONNULL_END
