/*
 * ZGMoviePlayer.h
 *
 * Copyright (c) 2017 HFLive
 * Copyright (c) 2017 Zhang Xiaolin
 *
 * This file is part of hfPlayer.
 */

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "ZGIJKMediaPlayer.h"

static const char *ZGMediaPlayrVersion = "0.3.6";
#define ZGMEDIAPLAYER_BUFFER_TIMEOUT        60*3
#define ZGMEDIAPLAYER_CONNECT_TIMEOUT       30
#define ZGMEDIAPLAYER_SHOW_POSITION_TIME    0.5

#define ZG_CHANNEL_MONO                     1
#define ZG_CHANNEL_STEREO                   2

typedef NS_ENUM(NSInteger,PlayerState)
{
    PLAYER_STATE_PREPARE,
    PLAYER_STATE_PLAY,      //video play
    PLAYER_STATE_AUDIO_PLAY,
    PLAYER_STATE_BUFFEREMPTY,
    PLAYER_STATE_BUFFERREADY,
    PLAYER_STATE_LOADTIMEUPDATE,
    PLAYER_STATE_KEYFRAME,
    PLAYER_STATE_TIMEOUT,
    PLAYER_STATE_COMPLETED,
    PLAYER_STATE_ERROR,
    PLAYER_STATE_SEEK_COMPLETED
};

typedef NS_ENUM(NSInteger,ZGPlayerThirdPartyCommand) {
    COMMAND_WHITEBOARD_MAIN_SHOW,
    COMMAND_PLAYER_MAIN_SHOW,
    
};
typedef NS_ENUM(NSInteger,ZGPlayerAndWhiteboardCurOpenType) {
    COMMAND_CURRENT_OPEN_NONE,
    COMMAND_CURRENT_OPEN_WHITEBOARD,
    COMMAND_CURRENT_OPEN_COURSEWARE,
    COMMAND_CURRENT_OPEN_COURSEWARE_AND_WHITEBOARD,
    
};

@protocol PlayerStateDelegate <NSObject>

@optional

-(void) onPlayerStateChanged:(PlayerState) playerState;

-(void) onCurrentPosition:(NSTimeInterval)curPos totalDuration:(NSTimeInterval)duration;
-(void) onWhiteboardData:(NSData*)data;
-(void) onWhiteboardOperationIndex:(int)operationIndex;
-(void) onCurrentOpenType:(ZGPlayerAndWhiteboardCurOpenType)type;
-(void) onCurrentCameraState:(int)cameraState;
-(void) onCurrentScreenState:(int)screenState;
-(void) onCommand:(ZGPlayerThirdPartyCommand)command param:(int)param;

@end

@interface ZGMoviePlayer : NSObject

/*
 * 播放器类型
 * TYPE_UNKNOW_PLAYER   未知类型
 * TYPE_FFMOIVE_PLAYER  FFplayer播放器
 * TYPE_AVMOIVE_PLAYER  AVPlayer播放器
 * TYPE_MPMOIVE_PLAYER  MPMoviePlayer播放器,iOS9之后被弃用
 */
typedef enum ZGPlayerType {
    TYPE_UNKNOW_PLAYER  = 0,
    TYPE_FFMOIVE_PLAYER = 1,
    TYPE_AVMOIVE_PLAYER = 2,
    TYPE_MPMOIVE_PLAYER = 3,
} ZGPlayerType;




@property(nonatomic, strong) NSURL*             url;            // 拉流地址

@property(nonatomic,weak) id<PlayerStateDelegate> delegate;

// 初始化播放器
- (id)init;

- (id)initWithServer:(NSString *)serverAddr;

// 设置本地服务地址
- (void)setServerAddr:(NSString *)serverAddr;

// 设置播放地址
- (BOOL)setContentURL:(NSURL *)aUrl;

// 设置播放地址和解密密HLS需要的Key
- (BOOL)setContentURLWithKey:(NSURL *)aUrl key:(NSString*)key;

//avplayer 播放加密视频开启画中画功能
- (BOOL)setM3u8ContextToAVPlayer:(NSString*)m3u8Context m3u8Key:(NSString*)m3u8Key picinpicDelegate:(id)picinpicDelegate;

- (BOOL)setContentURLToAVPlayer:(NSURL *)aUrl picinpicDelegate:(id)picinpicDelegate;

//开启画中画功能
- (BOOL)startPictureinPicture;

//关闭画中画功能
- (void)stopPictureinPicture;

// 重启
- (void)reset;

// 设置播放器渲染视图
- (void)setView:(UIView *)playerView;

// 移除播放器渲染视图
- (void)removeView;

// 启动播放准备工作
- (void)prepareToPlay;

// 播放
- (void)play;


// 暂停
- (void)pause;

// 停止
- (void)stop;

// 是否处于播放状态
- (BOOL)isPlaying;

// 关闭播放器
- (void)shutdown;

// 静音
- (void)mute:(BOOL)mute;

// 设置超时时间
- (void)setBufferTimeOut:(UInt64)bufferTimeOut;

// 设置填充模式
- (void)setScalingMode: (IJKMPMovieScalingMode) aScalingMode;

// 获取当前播放时间
- (NSTimeInterval)currentPlaybackTime;

// 获取播放时长
- (NSTimeInterval)duration;

// 获取已缓存的时间
- (NSTimeInterval)playableDuration;

// 跳转到指定时刻
- (void)seek:(NSTimeInterval)aSeekTime;

// 设置音量
- (void)setPlaybackVolume:(float)volume;

// 获取音量
- (float)playbackVolume;

// 设置进入后台是否暂停
- (void)setPauseInBackground:(BOOL)pause;

// 设置播放器类型（AVPlayer/IJKPlayer）,要在setContentURL之前设置
- (void)setPlayerType:(ZGPlayerType)type;

//注意更改播放速度要在视频开始播放之后才会生效
- (void)setPlayRate:(float)fRate;

//播放地址更改
-(void)resetVideoUrl:(NSString *)url;

@end
