/*
 * IJKMediaFramework.h
 *
 * Copyright (c) 2013 Bilibili
 * Copyright (c) 2013 Zhang Rui <bbcallen@gmail.com>
 *
 * This file is part of ijkPlayer.
 *
 * ijkPlayer is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * ijkPlayer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with ijkPlayer; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#import <UIKit/UIKit.h>

//! Project version number for IJKMediaFramework.
FOUNDATION_EXPORT double IJKMediaFrameworkVersionNumber;

//! Project version string for IJKMediaFramework.
FOUNDATION_EXPORT const unsigned char IJKMediaFrameworkVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <IJKMediaFrameworkWithSSL/PublicHeader.h>
#import <ZGIJKMediaFramework/ZGIJKMediaPlayback.h>
#import <ZGIJKMediaFramework/ZGIJKMPMoviePlayerController.h>
#import <ZGIJKMediaFramework/ZGIJKFFOptions.h>
#import <ZGIJKMediaFramework/ZGIJKFFMoviePlayerController.h>
#import <ZGIJKMediaFramework/ZGIJKAVMoviePlayerController.h>
#import <ZGIJKMediaFramework/ZGIJKMediaModule.h>
#import <ZGIJKMediaFramework/ZGIJKMediaPlayer.h>
#import <ZGIJKMediaFramework/ZGIJKNotificationManager.h>
#import <ZGIJKMediaFramework/ZGIJKKVOController.h>
#import <ZGIJKMediaFramework/ZGMoviePlayer.h>

// backward compatible for old names
#define ZGIJKMediaPlaybackIsPreparedToPlayDidChangeNotification ZGIJKMPMediaPlaybackIsPreparedToPlayDidChangeNotification
#define ZGIJKMoviePlayerLoadStateDidChangeNotification ZGIJKMPMoviePlayerLoadStateDidChangeNotification
#define ZGIJKMoviePlayerPlaybackDidFinishNotification ZGIJKMPMoviePlayerPlaybackDidFinishNotification
#define ZGIJKMoviePlayerPlaybackDidFinishReasonUserInfoKey ZGIJKMPMoviePlayerPlaybackDidFinishReasonUserInfoKey
#define ZGIJKMoviePlayerPlaybackStateDidChangeNotification ZGIJKMPMoviePlayerPlaybackStateDidChangeNotification
#define ZGIJKMoviePlayerIsAirPlayVideoActiveDidChangeNotification ZGIJKMPMoviePlayerIsAirPlayVideoActiveDidChangeNotification
#define ZGIJKMoviePlayerVideoDecoderOpenNotification ZGIJKMPMoviePlayerVideoDecoderOpenNotification
#define ZGIJKMoviePlayerFirstVideoFrameRenderedNotification ZGIJKMPMoviePlayerFirstVideoFrameRenderedNotification
#define ZGIJKMoviePlayerFirstAudioFrameRenderedNotification ZGIJKMPMoviePlayerFirstAudioFrameRenderedNotification
#define ZGIJKMPMoviePlayerAccurateSeekCompleteNotification ZGIJKMPMoviePlayerAccurateSeekCompleteNotification

