#import <Foundation/Foundation.h>
#import "WebRTC.h"
#import "RTCMacros.h"

static const char *ZGWebrtcVersion = "0.1.20";

@protocol RtcFactoryDelegate <NSObject>
- (void)onCreateView:(RTCEAGLVideoView*)view
                 streamID:(NSString*)streamID
                clientType:(ClientType)clientType;
- (void)onCreateSdp:(NSString *)handleId
          streamID:(NSString*)streamID
                sdp:(RTCSessionDescription *)sdp;
- (void)onCreateCandidate:(NSString *)handleId streamID:(NSString*)streamID candidate:(RTCIceCandidate *)candidate;
- (void)onCreateSubscriber:(NSString *)handleId streamID:(NSString *)streamID;
@optional
- (void)onViewSizeChanged:(RTCEAGLVideoView *)videoView streamID:(NSString*)streamID didChangeVideoSize:(CGSize)size;
- (void)onVolumeChanged:(NSString*)handleID didChangeVolume:(unsigned short)volume;
- (void)onIceState:(RTCIceConnectionState)state handleId:(NSString *)handleId streamID:(NSString*)streamID clientType:(ClientType)clientType;
- (void)onOpenCameraFailed;
- (void)onSendStats:(RTCMediaStats *)stats;
- (void)onRecieveStats:(RTCMediaStats *)stats;
- (void)onLogOut:(NSString *)logInfo;
- (void)onSnapshot:(UIImage*)snapshot;
@end

@interface RtcFactory : NSObject <RTCPeerConnectionDelegate,RTCVideoViewDelegate,RTCAudioSinkDelegate,RtcCameraDelegate>

- (instancetype)init;

@property(nonatomic, weak) id<RtcFactoryDelegate> delegate;

@property(nonatomic, assign) BOOL smallClass;


/**
 设置小班课
 
 @param smallClass 是否为小班课
 */
- (void)setSmallClass:(BOOL)smallClass;



/**
 是否推送视频

 @param bVideo 视频推送开关
 */
- (void)setLocalVideoEnable:(BOOL)bVideo;

/**
 设置所有流声音大小
 
 @param volume 声音大小,范围(0-10)
 */
- (void)setVolume:(double)volume;

/**
 是否推送音频
 
 @param bAudio 音频推送开关
 */
- (void)setLocalAudioEnable:(BOOL)bAudio;

/**
 静音设置🔇

 @param bMute 是否静音
 */
- (void)speakMute:(BOOL)bMute;


/**
 创建推流用户

 @param handleId 推流用户ID
 */
- (void)setPublisher:(NSString *)handleId;

/**
 推流用户设置服务器sdp

 @param handleId 推流用户ID
 @param jsep 远程服务器sdp信息
 */
- (void)setPublisherRemoteJsep:(NSString *)handleId dict:(NSDictionary *)jsep;

/**
  订阅用户设置远程推流用户

 @param handleId 远程用户ID
 @param streamID 远程用户采集设备类型
 @param clientType 用户角色类型：老师/学生
 */
- (void)setSubscriberHandleRemotePublisher: (NSString *)handleId streamID:(NSString*)streamID clientType:(ClientType)clientType;

/**
 订阅用户设置远程sdp

 @param handleId 远程用户的ID
 @param streamID 远程用户采集设备类型
 @param jsep 远程sdp
 */
- (void)setSubscriberHandleRemoteJsep: (NSString *)handleId  streamID:(NSString*)streamID dict:(NSDictionary *)jsep;

/**
 推流断开

 @param handleId 拉取的连麦用户ID
 @param streamID 流类型
 */
- (void)stopPull:(NSString *)handleId streamID:(NSString *)streamID;

/// 是否正在推流
-(bool)isPushing;

/**
 停止本地推流
 */
- (void)stopPublish;

/**
 远程视频显示控制

 @param handleId 当前连麦用户ID
 @param bShow 是否显示视频
 */
- (void)showRemoteView:(NSString *)handleId showView:(BOOL)bShow;

/**
 切换摄像头
 */
- (void)switchCamera;

/**
 播放
 */
- (void)play;

/**
 暂停
 */
- (void)pause;

/**
 允许回调RTC状态信息
 */
- (void)enbleRTCStats;

/**
 获取网络传输帧率,多个通道的平均帧率

 @return 帧率
 */
- (int)GetNetFrameRate;

/**
 获取网络传输码率

 @return 码率(kbps)
 */
- (double)GetNetBitrate;

/**
 设置本地推送码

 @param minBitrateBps 最小码率（bps）
 @param curBitrateBps 正常推送参考码率（bps）
 @param maxBitrateBps 最大码率（bps）
 */
- (void)setNetBitrate:(NSNumber*)minBitrateBps curBitrate:(NSNumber*)curBitrateBps maxBitrate:(NSNumber*)maxBitrateBps;

/**
 关闭连麦
 */
- (void)close;

/**
 获取camera的截图,camera没开启时主动开启并截图
 通过onSnapshot回调截图
 */
- (void)getSnapshot;

/**
 开启关闭日志功能 true打开，false 关闭
 */

-(void)logOutput:(BOOL)logEnable;

/**
 开启预览
 */
-(void)startPreview;


/**
 关闭预览
 */
-(void)stopPreview;


@end

