//
//  OIMCore.h
//
//  Created by zxl on 2020/8/7.
//  Copyright © 2020 zxl. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "oim_types.h"

using namespace offcn::im;

@protocol OIMCoreDelegate <NSObject>
-(void)OnOImCoreMessageWithMessage:(const char *_Nonnull)message msgLength:(int)len;
-(void)OnOImCoreEventWithCode:(OImEventCode)code errorCode:(int)nErrorCode context:(const char *_Nonnull)context;
@end


NS_ASSUME_NONNULL_BEGIN

@interface OIMCoreAdapter : NSObject
@property(nonatomic, weak) id<OIMCoreDelegate> delegate;

+ (instancetype)sharedOIMCore;
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;
- (id)copy NS_UNAVAILABLE;
- (id)mutableCopy NS_UNAVAILABLE;

- (void)Initialize;

/**
 *    connect to im server
 *
 *    @param     params                must contain server'ip and port in json format eg:
 *                                {"server_ip":"192.168.1.1", "server_port":123, "account_id":"123", "app_id":"123", "device_type":"windows", "token":"213", "account_id":"123", "session_id":"1223", "connection_type":"kcp"}
 */
-(void)ConnectImServerWithParam:(NSString*)param;

/**
 *    与服务器断开连接
 */
-(void)DisConnectImServer;

/**
 * 发送消息
 *
 *    @param    message        message data, size less than 256 BYTES
 *    @param    type        message's type
 */
-(void)SendUserMessage:(NSString*)message length:(int)len type:(OImMsgType)type;
@end


NS_ASSUME_NONNULL_END
