//
//  OIMCore.h
//
//  Created by zxl on 2020/8/7.
//  Copyright © 2020 zxl. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

@protocol OIMCoreDelegate <NSObject>
-(void)OnOImCoreMessageWithMessage:(const char *_Nonnull)message msgLength:(int)len;
-(void)OnOImCoreEventWithCode:(int)code context:(const char *_Nonnull)context;
@end

typedef NS_ENUM(NSInteger, OImMsgType) {
    kMsg_Type_Normal,          //正常的聊天消息
    kMsg_Type_Recv_Confirm,    //收到服务端发来的消息确认消息
};

NS_ASSUME_NONNULL_BEGIN

@interface OIMCoreAdapter : NSObject
@property(nonatomic, weak) id<OIMCoreDelegate> delegate;

+ (instancetype)sharedOIMCore;
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;
- (id)copy NS_UNAVAILABLE;
- (id)mutableCopy NS_UNAVAILABLE;

- (void)Initialize;
/**
 *    连接服务器
 *
 *    @param     param                must contain server'ip and port in json format eg:{"server_ip": "xxxx", "server_port": 123}
 */
-(void)ConnectImServerWithParam:(NSString*)param;

/**
 *    与服务器断开连接
 */
-(void)DisConnectImServer;

/**
 * 发送消息
 *
 *    @param    message        message data, size less than 256 BYTES
 *    @param    type        message's type
 */
-(void)SendUserMessage:(NSString*)message length:(int)len type:(OImMsgType)type;
@end


NS_ASSUME_NONNULL_END
