//
//  ZYJSDImageCacheConfig.m
//  SDWebImage
//
//  Created by Bogdan on 09/09/16.
//  Copyright © 2016 Dailymotion. All rights reserved.
//

#import "ZYJSDImageCacheConfig.h"

static const NSInteger kDefaultCacheMaxCacheAge = 60 * 60 * 24 * 7; // 1 week

@implementation ZYJSDImageCacheConfig

- (instancetype)init {
    if (self = [super init]) {
        _shouldDisableiCloud = YES;
        _shouldDecompressImages = YES;
        _shouldCacheImagesInMemory = YES;
        _maxCacheAge = kDefaultCacheMaxCacheAge;
        _maxCacheSize = 20 * 1024 * 1024;
        if ([UIDevice currentDevice].systemVersion.floatValue>=9.0 && [UIDevice currentDevice].systemVersion.floatValue<10.0) {
            _shouldDecompressImages = NO;
            _shouldCacheImagesInMemory = NO;
        }
    }
    return self;
}

@end
