//
//  ZYJFSMEngine.m
//  ZYJRealReachability
//
//  Created by Dustturtle on 16/1/19.
//  Copyright © 2016 Dustturtle. All rights reserved.
//

#import "ZYJFSMEngine.h"
#import "ZYJReachState.h"
#import "ZYJReachStateWIFI.h"
#import "ZYJReachStateUnloaded.h"
#import "ZYJReachStateWWAN.h"
#import "ZYJReachStateUnReachable.h"
#import "ZYJReachStateLoading.h"

#if (!defined(DEBUG))
#define NSLog(...)
#endif

@interface ZYJFSMEngine()

@property (nonatomic, assign) RRStateID currentStateID;
@property (nonatomic, strong) NSArray *allStates;

@end

@implementation ZYJFSMEngine

- (id)init
{
    if (self = [super init])
    {
        // created only once
        _allStates = @[[ZYJReachStateUnloaded state], [ZYJReachStateLoading state], [ZYJReachStateUnReachable state], [ZYJReachStateWIFI state], [ZYJReachStateWWAN state]];
    }
    return self;
}

- (void)dealloc
{
    self.allStates = nil;
}

- (void)start
{
    self.currentStateID = RRStateUnloaded;
}

- (NSInteger)receiveInput:(NSDictionary *)dic
{
    NSError *error = nil;
    ZYJReachState *currentState = self.allStates[self.currentStateID];
    RRStateID newStateID = [currentState onEvent:dic withError:&error];
    if (error)
    {
        NSLog(@"onEvent error:%@", error);
    }
  
    RRStateID previousStateID = self.currentStateID;
    self.currentStateID = newStateID;
    //NSLog(@"curStateID is %@", @(self.currentStateID));
    
    return (previousStateID == self.currentStateID) ? -1 : 0;
}

- (BOOL)isCurrentStateAvailable
{
    if (self.currentStateID == RRStateUnReachable || self.currentStateID == RRStateWWAN
        || self.currentStateID == RRStateWIFI)
    {
        return YES;
    }
    else
    {
        return NO;
    }
}

@end

