//
//  ZYJMASConstraintMaker.h
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 20/07/13.
//  Copyright (c) 2013 cloudling. All rights reserved.
//

#import "ZYJMASConstraint.h"
#import "ZYJMASUtilities.h"

typedef NS_OPTIONS(NSInteger, MASAttribute) {
    MASAttributeLeft = 1 << NSLayoutAttributeLeft,
    MASAttributeRight = 1 << NSLayoutAttributeRight,
    MASAttributeTop = 1 << NSLayoutAttributeTop,
    MASAttributeBottom = 1 << NSLayoutAttributeBottom,
    MASAttributeLeading = 1 << NSLayoutAttributeLeading,
    MASAttributeTrailing = 1 << NSLayoutAttributeTrailing,
    MASAttributeWidth = 1 << NSLayoutAttributeWidth,
    MASAttributeHeight = 1 << NSLayoutAttributeHeight,
    MASAttributeCenterX = 1 << NSLayoutAttributeCenterX,
    MASAttributeCenterY = 1 << NSLayoutAttributeCenterY,
    MASAttributeBaseline = 1 << NSLayoutAttributeBaseline,
    
#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)
    
    MASAttributeFirstBaseline = 1 << NSLayoutAttributeFirstBaseline,
    MASAttributeLastBaseline = 1 << NSLayoutAttributeLastBaseline,
    
#endif
    
#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)
    
    MASAttributeLeftMargin = 1 << NSLayoutAttributeLeftMargin,
    MASAttributeRightMargin = 1 << NSLayoutAttributeRightMargin,
    MASAttributeTopMargin = 1 << NSLayoutAttributeTopMargin,
    MASAttributeBottomMargin = 1 << NSLayoutAttributeBottomMargin,
    MASAttributeLeadingMargin = 1 << NSLayoutAttributeLeadingMargin,
    MASAttributeTrailingMargin = 1 << NSLayoutAttributeTrailingMargin,
    MASAttributeCenterXWithinMargins = 1 << NSLayoutAttributeCenterXWithinMargins,
    MASAttributeCenterYWithinMargins = 1 << NSLayoutAttributeCenterYWithinMargins,

#endif
    
};

/**
 *  Provides factory methods for creating ZYJMASConstraints.
 *  Constraints are collected until they are ready to be installed
 *
 */
@interface ZYJMASConstraintMaker : NSObject

/**
 *	The following properties return a new ZYJMASViewConstraint
 *  with the first item set to the makers associated view and the appropriate ZYJMASViewAttribute
 */
@property (nonatomic, strong, readonly) ZYJMASConstraint *left;
@property (nonatomic, strong, readonly) ZYJMASConstraint *top;
@property (nonatomic, strong, readonly) ZYJMASConstraint *right;
@property (nonatomic, strong, readonly) ZYJMASConstraint *bottom;
@property (nonatomic, strong, readonly) ZYJMASConstraint *leading;
@property (nonatomic, strong, readonly) ZYJMASConstraint *trailing;
@property (nonatomic, strong, readonly) ZYJMASConstraint *width;
@property (nonatomic, strong, readonly) ZYJMASConstraint *height;
@property (nonatomic, strong, readonly) ZYJMASConstraint *centerX;
@property (nonatomic, strong, readonly) ZYJMASConstraint *centerY;
@property (nonatomic, strong, readonly) ZYJMASConstraint *baseline;

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)

@property (nonatomic, strong, readonly) ZYJMASConstraint *firstBaseline;
@property (nonatomic, strong, readonly) ZYJMASConstraint *lastBaseline;

#endif

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)

@property (nonatomic, strong, readonly) ZYJMASConstraint *leftMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *rightMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *topMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *bottomMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *leadingMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *trailingMargin;
@property (nonatomic, strong, readonly) ZYJMASConstraint *centerXWithinMargins;
@property (nonatomic, strong, readonly) ZYJMASConstraint *centerYWithinMargins;

#endif

/**
 *  Returns a block which creates a new ZYJMASCompositeConstraint with the first item set
 *  to the makers associated view and children corresponding to the set bits in the
 *  MASAttribute parameter. Combine multiple attributes via binary-or.
 */
@property (nonatomic, strong, readonly) ZYJMASConstraint *(^attributes)(MASAttribute attrs);

/**
 *	Creates a ZYJMASCompositeConstraint with type ZYJMASCompositeConstraintTypeEdges
 *  which generates the appropriate ZYJMASViewConstraint children (top, left, bottom, right)
 *  with the first item set to the makers associated view
 */
@property (nonatomic, strong, readonly) ZYJMASConstraint *edges;

/**
 *	Creates a ZYJMASCompositeConstraint with type ZYJMASCompositeConstraintTypeSize
 *  which generates the appropriate ZYJMASViewConstraint children (width, height)
 *  with the first item set to the makers associated view
 */
@property (nonatomic, strong, readonly) ZYJMASConstraint *size;

/**
 *	Creates a ZYJMASCompositeConstraint with type ZYJMASCompositeConstraintTypeCenter
 *  which generates the appropriate ZYJMASViewConstraint children (centerX, centerY)
 *  with the first item set to the makers associated view
 */
@property (nonatomic, strong, readonly) ZYJMASConstraint *center;

/**
 *  Whether or not to check for an existing constraint instead of adding constraint
 */
@property (nonatomic, assign) BOOL updateExisting;

/**
 *  Whether or not to remove existing constraints prior to installing
 */
@property (nonatomic, assign) BOOL removeExisting;

/**
 *	initialises the maker with a default view
 *
 *	@param	view	any ZYJMASConstraint are created with this view as the first item
 *
 *	@return	a new ZYJMASConstraintMaker
 */
- (id)initWithView:(MAS_VIEW *)view;

/**
 *	Calls install method on any ZYJMASConstraints which have been created by this maker
 *
 *	@return	an array of all the installed ZYJMASConstraints
 */
- (NSArray *)install;

- (ZYJMASConstraint * (^)(dispatch_block_t))group;

@end
