//
//  ZYJMASConstraint+ZYJPrivate.h
//  ZYJMasonry
//
//  Created by Nick Tymchenko on 29/04/14.
//  Copyright (c) 2014 cloudling. All rights reserved.
//

#import "ZYJMASConstraint.h"

@protocol ZYJMASConstraintDelegate;


@interface ZYJMASConstraint ()

/**
 *  Whether or not to check for an existing constraint instead of adding constraint
 */
@property (nonatomic, assign) BOOL updateExisting;

/**
 *	Usually ZYJMASConstraintMaker but could be a parent ZYJMASConstraint
 */
@property (nonatomic, weak) id<ZYJMASConstraintDelegate> delegate;

/**
 *  Based on a provided value type, is equal to calling:
 *  NSNumber - setOffset:
 *  NSValue with CGPoint - setPointOffset:
 *  NSValue with CGSize - setSizeOffset:
 *  NSValue with MASEdgeInsets - setInsets:
 */
- (void)setLayoutConstantWithValue:(NSValue *)value;

@end


@interface ZYJMASConstraint (Abstract)

/**
 *	Sets the constraint relation to given NSLayoutRelation
 *  returns a block which accepts one of the following:
 *    ZYJMASViewAttribute, UIView, NSValue, NSArray
 *  see readme for more details.
 */
- (ZYJMASConstraint * (^)(id, NSLayoutRelation))equalToWithRelation;

/**
 *	Override to set a custom chaining behaviour
 */
- (ZYJMASConstraint *)addConstraintWithLayoutAttribute:(NSLayoutAttribute)layoutAttribute;

@end


@protocol ZYJMASConstraintDelegate <NSObject>

/**
 *	Notifies the delegate when the constraint needs to be replaced with another constraint. For example
 *  A ZYJMASViewConstraint may turn into a ZYJMASCompositeConstraint when an array is passed to one of the equality blocks
 */
- (void)constraint:(ZYJMASConstraint *)constraint shouldBeReplacedWithConstraint:(ZYJMASConstraint *)replacementConstraint;

- (ZYJMASConstraint *)constraint:(ZYJMASConstraint *)constraint addConstraintWithLayoutAttribute:(NSLayoutAttribute)layoutAttribute;

@end
