//
//  UIView+ZYJMASShorthandAdditions.h
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 22/07/13.
//  Copyright (c) 2013 Jonas Budelmann. All rights reserved.
//

#import "View+ZYJMASAdditions.h"

#ifdef MAS_SHORTHAND

/**
 *	Shorthand view additions without the 'mas_' prefixes,
 *  only enabled if MAS_SHORTHAND is defined
 */
@interface MAS_VIEW (ZYJMASShorthandAdditions)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *left;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *top;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *right;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *bottom;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *leading;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *trailing;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *width;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *height;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *centerX;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *centerY;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *baseline;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *(^attribute)(NSLayoutAttribute attr);

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *firstBaseline;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *lastBaseline;

#endif

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *leftMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *rightMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *topMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *bottomMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *leadingMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *trailingMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *centerXWithinMargins;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *centerYWithinMargins;

#endif

#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000) || (__TV_OS_VERSION_MAX_ALLOWED >= 110000)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *safeAreaLayoutGuideTop API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *safeAreaLayoutGuideBottom API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *safeAreaLayoutGuideLeft API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *safeAreaLayoutGuideRight API_AVAILABLE(ios(11.0),tvos(11.0));

#endif

- (NSArray *)makeConstraints:(void(^)(ZYJMASConstraintMaker *make))block;
- (NSArray *)updateConstraints:(void(^)(ZYJMASConstraintMaker *make))block;
- (NSArray *)remakeConstraints:(void(^)(ZYJMASConstraintMaker *make))block;

@end

#define MAS_ATTR_FORWARD(attr)  \
- (ZYJMASViewAttribute *)attr {    \
    return [self mas_##attr];   \
}

@implementation MAS_VIEW (ZYJMASShorthandAdditions)

MAS_ATTR_FORWARD(top);
MAS_ATTR_FORWARD(left);
MAS_ATTR_FORWARD(bottom);
MAS_ATTR_FORWARD(right);
MAS_ATTR_FORWARD(leading);
MAS_ATTR_FORWARD(trailing);
MAS_ATTR_FORWARD(width);
MAS_ATTR_FORWARD(height);
MAS_ATTR_FORWARD(centerX);
MAS_ATTR_FORWARD(centerY);
MAS_ATTR_FORWARD(baseline);

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)

MAS_ATTR_FORWARD(firstBaseline);
MAS_ATTR_FORWARD(lastBaseline);

#endif

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)

MAS_ATTR_FORWARD(leftMargin);
MAS_ATTR_FORWARD(rightMargin);
MAS_ATTR_FORWARD(topMargin);
MAS_ATTR_FORWARD(bottomMargin);
MAS_ATTR_FORWARD(leadingMargin);
MAS_ATTR_FORWARD(trailingMargin);
MAS_ATTR_FORWARD(centerXWithinMargins);
MAS_ATTR_FORWARD(centerYWithinMargins);

#endif

#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000) || (__TV_OS_VERSION_MAX_ALLOWED >= 110000)

MAS_ATTR_FORWARD(safeAreaLayoutGuideTop);
MAS_ATTR_FORWARD(safeAreaLayoutGuideBottom);
MAS_ATTR_FORWARD(safeAreaLayoutGuideLeft);
MAS_ATTR_FORWARD(safeAreaLayoutGuideRight);

#endif

- (ZYJMASViewAttribute *(^)(NSLayoutAttribute))attribute {
    return [self mas_attribute];
}

- (NSArray *)makeConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *))block {
    return [self mas_makeConstraints:block];
}

- (NSArray *)updateConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *))block {
    return [self mas_updateConstraints:block];
}

- (NSArray *)remakeConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *))block {
    return [self mas_remakeConstraints:block];
}

@end

#endif
