//
//  UIView+ZYJMASAdditions.m
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 20/07/13.
//  Copyright (c) 2013 cloudling. All rights reserved.
//

#import "View+ZYJMASAdditions.h"
#import <objc/runtime.h>

@implementation MAS_VIEW (ZYJMASAdditions)

- (NSArray *)mas_makeConstraints:(void(^)(ZYJMASConstraintMaker *))block {
    self.translatesAutoresizingMaskIntoConstraints = NO;
    ZYJMASConstraintMaker *constraintMaker = [[ZYJMASConstraintMaker alloc] initWithView:self];
    block(constraintMaker);
    return [constraintMaker install];
}

- (NSArray *)mas_updateConstraints:(void(^)(ZYJMASConstraintMaker *))block {
    self.translatesAutoresizingMaskIntoConstraints = NO;
    ZYJMASConstraintMaker *constraintMaker = [[ZYJMASConstraintMaker alloc] initWithView:self];
    constraintMaker.updateExisting = YES;
    block(constraintMaker);
    return [constraintMaker install];
}

- (NSArray *)mas_remakeConstraints:(void(^)(ZYJMASConstraintMaker *make))block {
    self.translatesAutoresizingMaskIntoConstraints = NO;
    ZYJMASConstraintMaker *constraintMaker = [[ZYJMASConstraintMaker alloc] initWithView:self];
    constraintMaker.removeExisting = YES;
    block(constraintMaker);
    return [constraintMaker install];
}

#pragma mark - NSLayoutAttribute properties

- (ZYJMASViewAttribute *)mas_left {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeLeft];
}

- (ZYJMASViewAttribute *)mas_top {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeTop];
}

- (ZYJMASViewAttribute *)mas_right {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeRight];
}

- (ZYJMASViewAttribute *)mas_bottom {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeBottom];
}

- (ZYJMASViewAttribute *)mas_leading {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeLeading];
}

- (ZYJMASViewAttribute *)mas_trailing {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeTrailing];
}

- (ZYJMASViewAttribute *)mas_width {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeWidth];
}

- (ZYJMASViewAttribute *)mas_height {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeHeight];
}

- (ZYJMASViewAttribute *)mas_centerX {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeCenterX];
}

- (ZYJMASViewAttribute *)mas_centerY {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeCenterY];
}

- (ZYJMASViewAttribute *)mas_baseline {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeBaseline];
}

- (ZYJMASViewAttribute *(^)(NSLayoutAttribute))mas_attribute
{
    return ^(NSLayoutAttribute attr) {
        return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:attr];
    };
}

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)

- (ZYJMASViewAttribute *)mas_firstBaseline {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeFirstBaseline];
}
- (ZYJMASViewAttribute *)mas_lastBaseline {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeLastBaseline];
}

#endif

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)

- (ZYJMASViewAttribute *)mas_leftMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeLeftMargin];
}

- (ZYJMASViewAttribute *)mas_rightMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeRightMargin];
}

- (ZYJMASViewAttribute *)mas_topMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeTopMargin];
}

- (ZYJMASViewAttribute *)mas_bottomMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeBottomMargin];
}

- (ZYJMASViewAttribute *)mas_leadingMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeLeadingMargin];
}

- (ZYJMASViewAttribute *)mas_trailingMargin {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeTrailingMargin];
}

- (ZYJMASViewAttribute *)mas_centerXWithinMargins {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeCenterXWithinMargins];
}

- (ZYJMASViewAttribute *)mas_centerYWithinMargins {
    return [[ZYJMASViewAttribute alloc] initWithView:self layoutAttribute:NSLayoutAttributeCenterYWithinMargins];
}

#endif

#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000) || (__TV_OS_VERSION_MAX_ALLOWED >= 110000)

- (ZYJMASViewAttribute *)mas_safeAreaLayoutGuide {
    return [[ZYJMASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeBottom];
}
- (ZYJMASViewAttribute *)mas_safeAreaLayoutGuideTop {
    return [[ZYJMASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeTop];
}
- (ZYJMASViewAttribute *)mas_safeAreaLayoutGuideBottom {
    return [[ZYJMASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeBottom];
}
- (ZYJMASViewAttribute *)mas_safeAreaLayoutGuideLeft {
    return [[ZYJMASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeLeft];
}
- (ZYJMASViewAttribute *)mas_safeAreaLayoutGuideRight {
    return [[ZYJMASViewAttribute alloc] initWithView:self item:self.safeAreaLayoutGuide layoutAttribute:NSLayoutAttributeRight];
}

#endif

#pragma mark - associated properties

- (id)mas_key {
    return objc_getAssociatedObject(self, @selector(mas_key));
}

- (void)setMas_key:(id)key {
    objc_setAssociatedObject(self, @selector(mas_key), key, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

#pragma mark - heirachy

- (instancetype)mas_closestCommonSuperview:(MAS_VIEW *)view {
    MAS_VIEW *closestCommonSuperview = nil;

    MAS_VIEW *secondViewSuperview = view;
    while (!closestCommonSuperview && secondViewSuperview) {
        MAS_VIEW *firstViewSuperview = self;
        while (!closestCommonSuperview && firstViewSuperview) {
            if (secondViewSuperview == firstViewSuperview) {
                closestCommonSuperview = secondViewSuperview;
            }
            firstViewSuperview = firstViewSuperview.superview;
        }
        secondViewSuperview = secondViewSuperview.superview;
    }
    return closestCommonSuperview;
}

@end
