//
//  UIView+ZYJMASAdditions.h
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 20/07/13.
//  Copyright (c) 2013 cloudling. All rights reserved.
//

#import "ZYJMASUtilities.h"
#import "ZYJMASConstraintMaker.h"
#import "ZYJMASViewAttribute.h"

/**
 *	Provides constraint maker block
 *  and convience methods for creating ZYJMASViewAttribute which are view + NSLayoutAttribute pairs
 */
@interface MAS_VIEW (ZYJMASAdditions)

/**
 *	following properties return a new ZYJMASViewAttribute with current view and appropriate NSLayoutAttribute
 */
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_left;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_top;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_right;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_bottom;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_leading;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_trailing;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_width;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_height;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_centerX;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_centerY;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_baseline;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *(^mas_attribute)(NSLayoutAttribute attr);

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_firstBaseline;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_lastBaseline;

#endif

#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_leftMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_rightMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_topMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_bottomMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_leadingMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_trailingMargin;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_centerXWithinMargins;
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_centerYWithinMargins;

#endif

#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000) || (__TV_OS_VERSION_MAX_ALLOWED >= 110000)

@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_safeAreaLayoutGuide API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_safeAreaLayoutGuideTop API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_safeAreaLayoutGuideBottom API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_safeAreaLayoutGuideLeft API_AVAILABLE(ios(11.0),tvos(11.0));
@property (nonatomic, strong, readonly) ZYJMASViewAttribute *mas_safeAreaLayoutGuideRight API_AVAILABLE(ios(11.0),tvos(11.0));

#endif

/**
 *	a key to associate with this view
 */
@property (nonatomic, strong) id mas_key;

/**
 *	Finds the closest common superview between this view and another view
 *
 *	@param	view	other view
 *
 *	@return	returns nil if common superview could not be found
 */
- (instancetype)mas_closestCommonSuperview:(MAS_VIEW *)view;

/**
 *  Creates a ZYJMASConstraintMaker with the callee view.
 *  Any constraints defined are added to the view or the appropriate superview once the block has finished executing
 *
 *  @param block scope within which you can build up the constraints which you wish to apply to the view.
 *
 *  @return Array of created ZYJMASConstraints
 */
- (NSArray *)mas_makeConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *make))block;

/**
 *  Creates a ZYJMASConstraintMaker with the callee view.
 *  Any constraints defined are added to the view or the appropriate superview once the block has finished executing.
 *  If an existing constraint exists then it will be updated instead.
 *
 *  @param block scope within which you can build up the constraints which you wish to apply to the view.
 *
 *  @return Array of created/updated ZYJMASConstraints
 */
- (NSArray *)mas_updateConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *make))block;

/**
 *  Creates a ZYJMASConstraintMaker with the callee view.
 *  Any constraints defined are added to the view or the appropriate superview once the block has finished executing.
 *  All constraints previously installed for the view will be removed.
 *
 *  @param block scope within which you can build up the constraints which you wish to apply to the view.
 *
 *  @return Array of created/updated ZYJMASConstraints
 */
- (NSArray *)mas_remakeConstraints:(void(NS_NOESCAPE ^)(ZYJMASConstraintMaker *make))block;

@end
