//
//  NSLayoutConstraint+ZYJMASDebugAdditions.m
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 3/08/13.
//  Copyright (c) 2013 Jonas Budelmann. All rights reserved.
//

#import "NSLayoutConstraint+ZYJMASDebugAdditions.h"
#import "ZYJMASConstraint.h"
#import "ZYJMASLayoutConstraint.h"

@implementation NSLayoutConstraint (ZYJMASDebugAdditions)

#pragma mark - ZYJ_description maps

+ (NSDictionary *)ZYJ_layoutRelationZYJ_descriptionsByValue {
    static dispatch_once_t once;
    static NSDictionary *ZYJ_descriptionMap;
    dispatch_once(&once, ^{
        ZYJ_descriptionMap = @{
            @(NSLayoutRelationEqual)                : @"==",
            @(NSLayoutRelationGreaterThanOrEqual)   : @">=",
            @(NSLayoutRelationLessThanOrEqual)      : @"<=",
        };
    });
    return ZYJ_descriptionMap;
}

+ (NSDictionary *)ZYJ_layoutAttributeZYJ_descriptionsByValue {
    static dispatch_once_t once;
    static NSDictionary *ZYJ_descriptionMap;
    dispatch_once(&once, ^{
        ZYJ_descriptionMap = @{
            @(NSLayoutAttributeTop)      : @"top",
            @(NSLayoutAttributeLeft)     : @"left",
            @(NSLayoutAttributeBottom)   : @"bottom",
            @(NSLayoutAttributeRight)    : @"right",
            @(NSLayoutAttributeLeading)  : @"leading",
            @(NSLayoutAttributeTrailing) : @"trailing",
            @(NSLayoutAttributeWidth)    : @"width",
            @(NSLayoutAttributeHeight)   : @"height",
            @(NSLayoutAttributeCenterX)  : @"centerX",
            @(NSLayoutAttributeCenterY)  : @"centerY",
            @(NSLayoutAttributeBaseline) : @"baseline",
            
#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000) || (__MAC_OS_X_VERSION_MIN_REQUIRED >= 101100)
            @(NSLayoutAttributeFirstBaseline) : @"firstBaseline",
            @(NSLayoutAttributeLastBaseline) : @"lastBaseline",
#endif
            
#if (__IPHONE_OS_VERSION_MIN_REQUIRED >= 80000) || (__TV_OS_VERSION_MIN_REQUIRED >= 9000)
            @(NSLayoutAttributeLeftMargin)           : @"leftMargin",
            @(NSLayoutAttributeRightMargin)          : @"rightMargin",
            @(NSLayoutAttributeTopMargin)            : @"topMargin",
            @(NSLayoutAttributeBottomMargin)         : @"bottomMargin",
            @(NSLayoutAttributeLeadingMargin)        : @"leadingMargin",
            @(NSLayoutAttributeTrailingMargin)       : @"trailingMargin",
            @(NSLayoutAttributeCenterXWithinMargins) : @"centerXWithinMargins",
            @(NSLayoutAttributeCenterYWithinMargins) : @"centerYWithinMargins",
#endif
            
        };
    
    });
    return ZYJ_descriptionMap;
}


+ (NSDictionary *)ZYJ_layoutPriorityZYJ_descriptionsByValue {
    static dispatch_once_t once;
    static NSDictionary *ZYJ_descriptionMap;
    dispatch_once(&once, ^{
#if TARGET_OS_IPHONE || TARGET_OS_TV
        ZYJ_descriptionMap = @{
            @(MASLayoutPriorityDefaultHigh)      : @"high",
            @(MASLayoutPriorityDefaultLow)       : @"low",
            @(MASLayoutPriorityDefaultMedium)    : @"medium",
            @(MASLayoutPriorityRequired)         : @"required",
            @(MASLayoutPriorityFittingSizeLevel) : @"fitting size",
        };
#elif TARGET_OS_MAC
        ZYJ_descriptionMap = @{
            @(MASLayoutPriorityDefaultHigh)                 : @"high",
            @(MASLayoutPriorityDragThatCanResizeWindow)     : @"drag can resize window",
            @(MASLayoutPriorityDefaultMedium)               : @"medium",
            @(MASLayoutPriorityWindowSizeStayPut)           : @"window size stay put",
            @(MASLayoutPriorityDragThatCannotResizeWindow)  : @"drag cannot resize window",
            @(MASLayoutPriorityDefaultLow)                  : @"low",
            @(MASLayoutPriorityFittingSizeCompression)      : @"fitting size",
            @(MASLayoutPriorityRequired)                    : @"required",
        };
#endif
    });
    return ZYJ_descriptionMap;
}

#pragma mark - ZYJ_description override

+ (NSString *)ZYJ_ZYJ_descriptionForObject:(id)obj {
    if ([obj respondsToSelector:@selector(mas_key)] && [obj mas_key]) {
        return [NSString stringWithFormat:@"%@:%@", [obj class], [obj mas_key]];
    }
    return [NSString stringWithFormat:@"%@:%p", [obj class], obj];
}

- (NSString *)ZYJ_description {
    NSMutableString *ZYJ_description = [[NSMutableString alloc] initWithString:@"<"];

    [ZYJ_description appendString:[self.class ZYJ_ZYJ_descriptionForObject:self]];

    [ZYJ_description appendFormat:@" %@", [self.class ZYJ_ZYJ_descriptionForObject:self.firstItem]];
    if (self.firstAttribute != NSLayoutAttributeNotAnAttribute) {
        [ZYJ_description appendFormat:@".%@", self.class.ZYJ_layoutAttributeZYJ_descriptionsByValue[@(self.firstAttribute)]];
    }

    [ZYJ_description appendFormat:@" %@", self.class.ZYJ_layoutRelationZYJ_descriptionsByValue[@(self.relation)]];

    if (self.secondItem) {
        [ZYJ_description appendFormat:@" %@", [self.class ZYJ_ZYJ_descriptionForObject:self.secondItem]];
    }
    if (self.secondAttribute != NSLayoutAttributeNotAnAttribute) {
        [ZYJ_description appendFormat:@".%@", self.class.ZYJ_layoutAttributeZYJ_descriptionsByValue[@(self.secondAttribute)]];
    }
    
    if (self.multiplier != 1) {
        [ZYJ_description appendFormat:@" * %g", self.multiplier];
    }
    
    if (self.secondAttribute == NSLayoutAttributeNotAnAttribute) {
        [ZYJ_description appendFormat:@" %g", self.constant];
    } else {
        if (self.constant) {
            [ZYJ_description appendFormat:@" %@ %g", (self.constant < 0 ? @"-" : @"+"), ABS(self.constant)];
        }
    }

    if (self.priority != MASLayoutPriorityRequired) {
        [ZYJ_description appendFormat:@" ^%@", self.class.ZYJ_layoutPriorityZYJ_descriptionsByValue[@(self.priority)] ?: [NSNumber numberWithDouble:self.priority]];
    }

    [ZYJ_description appendString:@">"];
    return ZYJ_description;
}

@end
