//
//  NSArray+ZYJMASShorthandAdditions.h
//  ZYJMasonry
//
//  Created by Jonas Budelmann on 22/07/13.
//  Copyright (c) 2013 Jonas Budelmann. All rights reserved.
//

#import "NSArray+ZYJMASAdditions.h"

#ifdef MAS_SHORTHAND

/**
 *	Shorthand array additions without the 'mas_' prefixes,
 *  only enabled if MAS_SHORTHAND is defined
 */
@interface NSArray (ZYJMASShorthandAdditions)

- (NSArray *)makeConstraints:(void(^)(ZYJMASConstraintMaker *make))block;
- (NSArray *)updateConstraints:(void(^)(ZYJMASConstraintMaker *make))block;
- (NSArray *)remakeConstraints:(void(^)(ZYJMASConstraintMaker *make))block;

@end

@implementation NSArray (ZYJMASShorthandAdditions)

- (NSArray *)makeConstraints:(void(^)(ZYJMASConstraintMaker *))block {
    return [self mas_makeConstraints:block];
}

- (NSArray *)updateConstraints:(void(^)(ZYJMASConstraintMaker *))block {
    return [self mas_updateConstraints:block];
}

- (NSArray *)remakeConstraints:(void(^)(ZYJMASConstraintMaker *))block {
    return [self mas_remakeConstraints:block];
}

@end

#endif
